/* $Id: hpe1432.c,v 1.169 1999/03/10 22:26:55 ericb Exp $ */
/* Copyright (C) 1995 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/*
 * Plug&Play library.  This code is a shell over the C-Library.
 *
 */
#ifdef VXIPNP

#define HPE1432_ERR_BASE                1000
#define HPE1432_ERR_NULL_POINTER        (HPE1432_ERR_BASE+1)
#define HPE1432_ERR_TOO_MANY_CHANNELS   (HPE1432_ERR_BASE+2)

#include <stdio.h>	/* needed for sprintf */
#include <ctype.h>
#include <string.h>
#ifndef WIN32
#include <varargs.h>	/* for flogprintf */
#endif
#include "sema.h"
#include "hpe1432.h"
#include "e1432.h"
#include "err1432.h"

#define GTL printf ("got to line %ld in file %s\n", __LINE__, __FILE__);

#define MAX_MODULES	64
#define LENGTH_STRING	32

long	pnptracelevel; /* set by hpe1432_setTraceLevel */


/***********************************************************************
 *  Global (to this file) data
 * 
 */


/* these are used by _init and info calls */
static struct e1432_hwconfig hwconfig[MAX_MODULES]; /* man_id = 0 for empty */
static SHORTSIZ16	LAs[MAX_MODULES];
static SHORTSIZ16	nummodules;

/* this tailer data is good until next readFloatXXData */
static struct e1432_trailer last_trailer;
static struct e1432_trailer last_trailer2;

/***********************************************************************
 *  static internal functions
 * 
 */


/* get interface name from front of resource parm */
static void i_extract_interface(char in[],char out[], int max)
{
int	i;

    i=0;
    out[0]='\0';

    while((in[i])&&(i<max-1)&&(in[i]!=':'))
    {
	out[i]=in[i];
	i++;
        out[i]='\0';
    }
}


/* convert list of addresses in resource to an array */
/* format xxxx::n,n,n[::xxx] */
static void i_rsrc_to_array(char rsrcName[],SHORTSIZ16 *LAs,
			    SHORTSIZ16 *nummodules,
		int maxmodules)
{
int	firstcolon;	/* true if found a colon */
int	secondcolon;	/* true if found second colon */
int	goFlag;	        /* still looking for a number */
int	src;


    firstcolon=0;
    secondcolon=0;
    *nummodules=0;
    /* advance past two colons */
    src=0;
    do {
	if(!rsrcName[src])
	    return;
	if(rsrcName[src]==':')
	{
	    if(firstcolon)
		secondcolon=1;
	    else
		firstcolon=1;
	}
	else
	    firstcolon=0;
	src++;
	if(src>=LENGTH_STRING)
	{
	    return;
	}
    } while(!secondcolon);

    do {
        /* convert number */
        LAs[(*nummodules)]=(SHORTSIZ16)atoi(&(rsrcName[src]));
        (*nummodules)++;

        /* advance to next non number, quit if \0 or : */
        goFlag=1;
        do {
	    if((!rsrcName[src])||(rsrcName[src]==':'))
	        return;
	    if(!isdigit(rsrcName[src]))
	        goFlag=0;
	    else
	        src++;
        } while (goFlag);
        /* advance to number */
        goFlag=1;
        do {
	    if((!rsrcName[src])||(rsrcName[src]==':'))
	        return;
	    if(isdigit(rsrcName[src]))
	        goFlag=0;
	    else
	        src++;
        } while (goFlag);
    } while (*nummodules<maxmodules);
    return;
}

static ViStatus err1432_to_PNP(SHORTSIZ16 serr)
{
ViStatus rv;
/* check this out - VXI plug&play returns error messages like
/* 
 * VI_ERROR_PARAMETER1
 * VI_ERROR_PARAMETER2
*/


    if(pnptracelevel&0x100)
	return(( ViStatus) serr);

#if 0
if(serr)
printf("semaphore error: %d  %s\n",(int)serr,e1432_get_error_string());
#endif

  switch(serr)
  {
    case 0:
	rv=VI_SUCCESS;
	break;
/*************************************************************************/
/*           VI_ERROR_PARAMETER2                                         */


    case ERR1432_EXPECT_GROUP:
    case ERR1432_EXPECT_CHANNEL:
	rv=VI_ERROR_PARAMETER2;
	break;
/*************************************************************************/
/*           VI_ERROR_PARAMETER3                                         */


    case ERR1432_ILLEGAL_INPUT_MODE	:
    case ERR1432_ILLEGAL_ANTI_ALIAS_MODE:
    case ERR1432_ILLEGAL_INPUT_SOURCE:
    case ERR1432_ILLEGAL_INPUT_GROUNDING:
    case ERR1432_ILLEGAL_COUPLING:
    case ERR1432_ILLEGAL_APPEND_STATUS_STATE:
    case ERR1432_ILLEGAL_BLOCKSIZE:
    case ERR1432_ILLEGAL_DATA_SIZE:
    case ERR1432_ILLEGAL_DATA_MODE :
    case ERR1432_ILLEGAL_DATA_PORT:
    case ERR1432_ILLEGAL_LBUS_MODE:
    case ERR1432_ILLEGAL_LBUS_STATE:
    case ERR1432_ILLEGAL_OVERLAP:
    case ERR1432_ILLEGAL_FILTER_PASS_MODE:
    case ERR1432_ILLEGAL_ANTI_ALIAS_DIG_MODE:
    case ERR1432_ILLEGAL_FILTER_BANDWIDTH:
    case ERR1432_ILLEGAL_SETTLING_TIME:
    case ERR1432_ILLEGAL_ZOOM_STATE:
    case ERR1432_ILLEGAL_CENTER_FREQ:
    case ERR1432_ILLEGAL_RAMP_STATE:
    case ERR1432_ILLEGAL_DECIMATION_OVERSAMPLE:
    case ERR1432_ILLEGAL_SPAN:
    case ERR1432_ILLEGAL_CLOCK_SOURCE:
    case ERR1432_ILLEGAL_MULTI_SYNC_MODE:
    case ERR1432_ILLEGAL_TTLTRG_LINE:
    case ERR1432_ILLEGAL_CLOCK_MASTER:
    case ERR1432_ILLEGAL_TRIGGERS_PER_ARM:
    case ERR1432_ILLEGAL_POST_TRIGGER_DELAY:
    case ERR1432_ILLEGAL_TRIGGER_SLOPE:
    case ERR1432_ILLEGAL_TRIGGER_MODE:
    case ERR1432_ILLEGAL_TRIGGER_CHANNEL:
    case ERR1432_ILLEGAL_ARM_STATE:
    case ERR1432_ILLEGAL_TRIGGER_STATE:
    case ERR1432_ILLEGAL_TRIGGER_EXT:
    case ERR1432_ILLEGAL_AMP_SCALE:
    case ERR1432_ILLEGAL_FILTER_FREQ:
    case ERR1432_ILLEGAL_RAMP_RATE:
    case ERR1432_ILLEGAL_SINE_FREQ:
    case ERR1432_ILLEGAL_SINE_PHASE:
    case ERR1432_ILLEGAL_SOURCE_COLA:
    case ERR1432_ILLEGAL_SOURCE_SUM:
    case ERR1432_ILLEGAL_SOURCE_MODE:
    case ERR1432_ILLEGAL_DUTY_CYCLE:
    case ERR1432_ILLEGAL_TACH_DECIMATE:
    case ERR1432_ILLEGAL_TACH_HOLDOFF:
    case ERR1432_ILLEGAL_TACH_MAX_TIME:
    case ERR1432_ILLEGAL_TACH_INPUT:
    case ERR1432_ILLEGAL_TACH_SLOPE:
    case ERR1432_ILLEGAL_TACH_LEVEL:
    case ERR1432_ILLEGAL_TACH_HYST:
    case ERR1432_WHICH_TRIGGER_LEVEL:
    case ERR1432_ILLEGAL_GROUP_MEAS_STATE:
    case ERR1432_RANGE_OUT_OF_LIMITS:
    case ERR1432_OFFSET_OUT_OF_LIMITS:
    case ERR1432_ILLEGAL_CLOCK_FREQ:
    case ERR1432_ILLEGAL_CLOCK_OVERSAMPLE:
	rv=VI_ERROR_PARAMETER3;
	break;
/*************************************************************************/
/*           VI_ERROR_PARAMETER4                                         */

    case ERR1432_ILLEGAL_TRIGGER_LEVEL:
	rv=VI_ERROR_PARAMETER4;
	break;
/*************************************************************************/
/*           VI_ERROR_PARAMETER5                                         */


/*************************************************************************/
/*           calibration failed                                         */

    case ERR1432_CALIBRATION_FAILURE:
	rv=VI_ERROR_CALIBRATION_FAILURE;
	break;

    case ERR1432_LOCK_FAILED:
        rv = VI_ERROR_TMO;	/* Lock failure shows up as timeout */
        break;
      
/* analog */
    case ERR1432_ILLEGAL_RANGE_DOWN:
    case ERR1432_ILLEGAL_RANGE_UP:
    case ERR1432_ILLEGAL_ACTIVE_CHANNEL:

/* data, getdata */
    case ERR1432_ILLEGAL_CHANNEL_ORDER:

/* filter */
    case ERR1432_FIFO_OVERRUN:

/* timing */
    case ERR1432_NO_PLL_LOCK:

/* trigger */
    case ERR1432_PRETRIGGER_GREATER_FIFO:



/* group, module, channel */
    case ERR1432_NO_GROUP:
    case ERR1432_NO_ID:
    case ERR1432_ILLEGAL_MODULE_COUNT:
    case ERR1432_NO_MOD_AT_LA:
    case ERR1432_INVALID_MODULE_OPTION:
    case ERR1432_NO_CHANNEL:
    case ERR1432_GROUP_NOT_CONTIGUOUS:
    case ERR1432_TOO_MANY_MODULES:

/* io, machine, interrupts */
    case ERR1432_STATUS_READ_TIMEOUT:
    case ERR1432_BUS_ERROR:
    case ERR1432_ILLEGAL_REGISTER_OFFSET:
    case ERR1432_ILLEGAL_INTR_MASK:
    case ERR1432_ILLEGAL_INTR_PRIORITY:
    case ERR1432_SYSTEM_TIME:
    case ERR1432_UNABLE_TO_OPEN_SICL:
    case ERR1432_UNABLE_TO_MAP_MEMORY:
    case ERR1432_ERROR_QUEUE_CORRUPT:
    case ERR1432_IONSRQ:

/* miscellaneous */
    case ERR1432_PARAMETER_UNEQUAL:
    case ERR1432_MALLOC:
    case ERR1432_REALLOC:
    case ERR1432_SIGVECTOR:
    case ERR1432_MEAS_STATE_NOT_RESPONDING:
    case ERR1432_AUTO_ZERO_TIMEOUT:
    case ERR1432_LIST_ERROR:
    case ERR1432_AUTO_ZERO_FAILURE:
    case ERR1432_ILLEGAL_MODE:

/* calibration and flash rom  */
    case ERR1432_BAD_CAL_BLOCK:
    case ERR1432_BAD_FLASH:
    case ERR1432_VPP_ERROR:
    case ERR1432_ROM_COMMAND:
    case ERR1432_ROM_BYTE_PROGRAM:
    case ERR1432_ROM_BLOCK_ERASE:

    case ERR1432_SELFTEST_FAILURE:

/* More misc */
    case ERR1432_DATA_MISALIGNED:
    case ERR1432_ILLEGAL_FIFO_SIZE:
    case ERR1432_HARDWARE_INCAPABLE:
    case ERR1432_FIRMWARE_ERROR:
    case ERR1432_ILLEGAL_AUTO_ZERO:
    case ERR1432_IO:
    case ERR1432_FILE:
    case ERR1432_SYNC_TIMEOUT:
    case ERR1432_I2C:

/* Source */
    case ERR1432_ACK_TIMEOUT:

/* Tach */

    case ERR1432_SICL_ERROR:
    case ERR1432_DMA_TIMEOUT:
    case ERR1432_DMA_ERROR:

/* Configuration */
    case ERR1432_CHAN_COUNT_MISMATCH:
    case ERR1432_SCA_NOT_CONTIG:
    case ERR1432_SELFTEST_FAILURE_SOURCE:
    case ERR1432_SOURCE_ERROR:
    case ERR1432_SOURCE_OVERLOAD:
    case ERR1432_SOURCE_SHUTDOWN:
    case ERR1432_ILLEGAL_CAL_DAC:
    case ERR1432_ILLEGAL_CALIN:
    case ERR1432_ILLEGAL_SUMBUS:
    case ERR1432_ILLEGAL_SOURCE_OUTPUT:

/* Dervish specific */
    case ERR1432_ILLEGAL_ARM_TRIG_COMBO:
    case ERR1432_ILLEGAL_PRE_ARM_MODE:
    case ERR1432_ILLEGAL_ARM_MODE:
    case ERR1432_ILLEGAL_WINDOW:
    case ERR1432_ILLEGAL_NUMBER_ORDERS:
    case ERR1432_ILLEGAL_PULSE_PER_REV:
    case ERR1432_ILLEGAL_DELTA_ORDER:
    case ERR1432_ILLEGAL_TEST_TIME:
    case ERR1432_ILLEGAL_ARM_TIME_INTERVAL:
    case ERR1432_ILLEGAL_ORDER_BLOCKSIZE:
    case ERR1432_ILLEGAL_TRIGGER_RPM:
    case ERR1432_ILLEGAL_CHANNEL_ADDRESS:
    case ERR1432_ILLEGAL_DELTA_MAX_ORDER:
    case ERR1432_ILLEGAL_ORDER_BINS:
    case ERR1432_PARAM_BLOCK_INIT:
    case ERR1432_ILLEGAL_TRIGGER_SOURCE:
    case ERR1432_ILLEGAL_RPM_INTERVAL:
    case ERR1432_ILLEGAL_RPM_LOW:
    case ERR1432_ILLEGAL_RPM_HIGH:
    case ERR1432_RPM_LOW_GREATER_HIGH:
    case ERR1432_RPM_TOO_LOW_FOR_SPAN:
    case ERR1432_RPM_TOO_HIGH_FOR_SPAN:
    case ERR1432_ILLEGAL_TRIG_SOURCE_MODE:
    case ERR1432_RPM_HIGH_NOT_MULT_INTERVAL:
    case ERR1432_MALLOC_BLOCK_DATA:
    case ERR1432_ILLEGAL_CP_BLOCKSIZ:
    case ERR1432_ILLEGAL_SKIP_N_TACHS:
    case ERR1432_ILLEGAL_NUM_DATA_CHANNELS:
    case ERR1432_ILLEGAL_DATA_MASK:
    case ERR1432_NO_ARM_CHANNEL:
    case ERR1432_ILLEGAL_AUTO_TIME:
    case ERR1432_ILLEGAL_MAX_ORDER:
    case ERR1432_ILLEGAL_COMP_POWER_START:
    case ERR1432_ILLEGAL_COMP_POWER_BLOCKSIZE:
    case ERR1432_ILLEGAL_PPR_SKIP_TACH:
    case ERR1432_ILLEGAL_SUB_CHANNEL:
    case ERR1432_ILLEGAL_CHAN_ORDER:
    case ERR1432_NOT_TACH_CHANNEL:
    case ERR1432_ILLEGAL_MASTER_SLAVE:
    case ERR1432_ILLEGAL_FALSE_TACH_REJ:
    case ERR1432_ILLEGAL_TRIGGER_ACCURACY:
    case ERR1432_ILLEGAL_EXT_TRIGGER_LEVEL:
    case ERR1432_ILLEGAL_EXT_TRIGGER_CHAN:
    case ERR1432_ILLEGAL_EXT_TRIGGER_SLOPE:
    case ERR1432_ILLEGAL_EXT_TRIGGER_HYST:
    case ERR1432_TACH_HOLDOFF_RPM_HIGH_WRONG:
    case ERR1432_ILLEGAL_RPM_SMOOTHING:
    case ERR1432_ILLEGAL_OT_BANDWIDTH:
    case ERR1432_ILLEGAL_NUM_TACH_CHAN:
    case ERR1432_ILLEGAL_DEBUG_FLAG:
    case ERR1432_ILLEGAL_TRIGGER_POSITION:
    case ERR1432_ILLEGAL_TRIGGER_MASTER:
    case ERR1432_ILLEGAL_SAMPLE_MODE:
    case ERR1432_RPM_STEP_LESS_INTERVAL:
    case ERR1432_ILLEGAL_EXT_TRIGGER_NUM:
    case ERR1432_TRIG_MASTER_GREATER_NUM_CHAN:
    case ERR1432_ILLEGAL_RPM_MAX_STEP:
    case ERR1432_ILLEGAL_AVG_MODE:
    case ERR1432_ILLEGAL_AVG_NUMBER:
    case ERR1432_NO_TACH_BOARD:
    case ERR1432_ILLEGAL_TTL_TRIG_PAIR:
    case ERR1432_ILLEGAL_USE_LBUS:
    case ERR1432_ILLEGAL_CHANNEL_COUNT:
    case ERR1432_ILLEGAL_EXT_TRIGGER_CHANNEL:
    case ERR1432_ONLY_TWO_TACH_CHAN:
    case ERR1432_NO_INPUT_SCA:
    case ERR1432_ILLEGAL_RPM_HIGH_SKIP_TACH:
    case ERR1432_MALLOC_WINDOW_BUF:
    case ERR1432_ILLEGAL_OT_INPUT_SCA:
    case ERR1432_NEED_DRAM:
    case ERR1432_ILLEGAL_ARM_CHANNEL:
    case ERR1432_CURRENT_RPM_CHANNEL:
    case ERR1432_ILLEGAL_MEAS_TIME_LENGTH:
    case ERR1432_ILLEGAL_PRE_ARM_RPM:
    case ERR1432_ILLEGAL_CALC_DATA:

    case ERR1432_ORDER_MULTIPASS_OFF:
    case ERR1432_ORDER_OVERSAMPLE_OFF:
    case ERR1432_LBUS_TEST_TIMEOUT:
    case ERR1432_LBUS_TEST_BAD_DATA:
    case ERR1432_ILLEGAL_LBUS_TEST_MODE:
    case ERR1432_OT_LOST_POINT:
    case ERR1432_OT_LOST_FALLING_BEHIND:
    case ERR1432_OT_FIFO_OVERFLOW:
    case ERR1432_OT_UNKNOWN_ERROR:


    case ERR1432_BAD_INTERNAL_COMMAND:
    case ERR1432_CAL_DISALLOWED:
    case ERR1432_SRC0_XFRDATA_TOO_LONG:
    case ERR1432_SRC0_XFRBUF_NRDY:
    case ERR1432_ILLEGAL_SRC_BLKSIZE:
    case ERR1432_ILLEGAL_SRC_SPAN:
    case ERR1432_ILLEGAL_SRC_CENTERFREQ:
    case ERR1432_FLASH_INVALID:
    case ERR1432_ILLEGAL_PRE_ARM_CHANNEL:
    case ERR1432_ILLEGAL_SRCBUFFER_MODE:
    case ERR1432_SOURCE_OVERREAD:
    case ERR1432_TACH_BUFFER_OVERFLOW:
    case ERR1432_TACH_XFER_TIMEOUT:
    case ERR1432_REJECT_SLAVE_TRIGGER:

    case ERR1432_COUPLING_FREQ_OUT_OF_LIMITS:
    case ERR1432_ILLEGAL_WEIGHTING:
    case ERR1432_INPUT_OFFSET_OUT_OF_LIMITS:
    case ERR1432_AUTOZERO_OFFSET_OUT_OF_LIMITS:
    case ERR1432_DUPLICATE_TACH_TIME:
    default:



	rv=VI_ERROR_SYSTEM_ERROR;

  }

  return rv;
}

#ifdef MICROSOFT_OS
static char semabinloc[]="C:\\HPE1432\\LIB\\SEMA.BIN";
#else
static char semabinloc[]="/opt/e1432/lib/sema.bin";
#endif

/*************************************************************************/
/* Plug&Play required functions */

/*
 *  rsrcName  vxi::n,m,o,p...[::INSTR]
 */

static	E1432ID	semaID;	/* e1432 hardware ID */

/* the init function has been split into three parts, for lower level control
 * of library and hardware initialization
*/

static char		iface[15];  /* interface usually vxi */

ViStatus _VI_FUNC 
hpe1432_initA(ViRsrc rsrcName, ViBoolean id_query,
			ViBoolean reset, ViPSession vi)
{
SHORTSIZ16	serror;	/* e1432 error */
int i;

    *vi=VI_NULL;

    pnptracelevel=0;

    /* clear out old configs */
    for(i=0;i<MAX_MODULES;i++)
	hwconfig[i].man_id=0; /* man_id is 0 for empty flag */

    i_extract_interface(rsrcName,iface,15);

    serror=e1432_set_interface_addr(iface);
    if(serror)
	return err1432_to_PNP(serror);

    serror=e1432_init_io_driver();
    if(serror)
	return err1432_to_PNP(serror);

    return VI_SUCCESS;
}



ViStatus _VI_FUNC 
hpe1432_initB(ViRsrc rsrcName, ViBoolean id_query,
			ViBoolean reset, ViPSession vi)
{
SHORTSIZ16	serror;	/* e1432 error */
int		i;	/* general loop index */

    /* get logical addresses */
    i_rsrc_to_array(rsrcName,LAs,&nummodules,MAX_MODULES);


    if((reset)&&(nummodules>0))
    {
        /* test each module for response to hwconfig */
        for(i=0;i<nummodules;i++)
        {
            serror=e1432_get_hwconfig(1,&(LAs[i]),&(hwconfig[i]));
            if(serror)
	    {
                serror=e1432_install(1, &(LAs[i]), 0, semabinloc);
                if(serror)
		{
	   	    return err1432_to_PNP(serror);
		}
	    }

	    /* call again to fill hwconfig array */
            serror=e1432_get_hwconfig(1,&(LAs[i]),&(hwconfig[i]));
            if(serror)
	   	    return err1432_to_PNP(serror);
	}
    }


#if 0
	This is the older, faster initialization of the boards.
	Unfortunetly, the VISA implementation on HP-UX, which
	rest on SICL, is too shakey to handle this simutaneous
	loading of sema.bin.

    if((reset)&&(nummodules>0))
    {
        numToLoad=0;
        /* test each module for response to hwconfig */
        for(i=0;i<nummodules;i++)
        {
            serror=e1432_get_hwconfig(1,&(LAs[i]),&(hwconfig[i]));
            if(serror)
	    {
   	        loadLAs[numToLoad++]=LAs[i];
	    }
	}

	/* load sema.bin for modules desiring it */
        if(numToLoad>0)
        {
            serror=e1432_install(numToLoad, &(loadLAs[0]), 0, semabinloc);
    	    if(serror)
		return err1432_to_PNP(serror);
	}

        for(i=0;i<nummodules;i++)
        {
            serror=e1432_get_hwconfig(1,&(LAs[i]),&(hwconfig[i]));
    	    if(serror)
		return err1432_to_PNP(serror);
        }
    }
#endif



    return VI_SUCCESS;

}

/* Replacement for hpe1432_initB, which does the same thing except it
   uses the user's specified sema.bin location (if specified), rather
   than hardcoding the default location.  If the user hasn't specified
   a path to sema.bin, then this uses the default location.

   Note that sema.bin is installed only if there is not already a
   sema.bin installed in the module. */
ViStatus _VI_FUNC 
hpe1432_initB2(ViRsrc rsrcName, ViBoolean id_query,
	       ViBoolean reset, ViPSession vi)
{
    SHORTSIZ16 serror;
    const char *path;
    int     i;

    if (i1432_install_file != NULL)
	path = i1432_install_file;
    else
	path = semabinloc;

    /* Get logical addresses */
    i_rsrc_to_array(rsrcName, LAs, &nummodules, MAX_MODULES);

    if (reset && nummodules > 0)
	/* Test each module for response to hwconfig */
	for (i = 0; i < nummodules; i++)
	{
	    serror = e1432_get_hwconfig(1, &(LAs[i]), &(hwconfig[i]));
	    if (serror)
	    {
		/* The e1432_get_hwconfig returned an error, so we
		   probably need to install sema.bin. */
		serror = e1432_install(1, &(LAs[i]), 0, path);
		if (serror)
		    return err1432_to_PNP(serror);

		/* Call again to fill hwconfig array */
		serror = e1432_get_hwconfig(1, &(LAs[i]), &(hwconfig[i]));
		if (serror)
		    return err1432_to_PNP(serror);
	    }
	}

    return VI_SUCCESS;
}

/* Replacement for hpe1432_initB, which does the same thing except it
   uses the user's specified sema.bin location (if specified), rather
   than hardcoding the default location.  If the user hasn't specified
   a path to sema.bin, then this uses the default location.

   In addition, this version unconditionally installs the firmware,
   where hpe1432_initB and hpe1432_initB2 install only if there is no
   existing firmware. */
ViStatus _VI_FUNC 
hpe1432_initB3(ViRsrc rsrcName, ViBoolean id_query,
	       ViBoolean reset, ViPSession vi)
{
    SHORTSIZ16 serror;
    const char *path;

    if (i1432_install_file != NULL)
	path = i1432_install_file;
    else
	path = semabinloc;

    /* Get logical addresses */
    i_rsrc_to_array(rsrcName, LAs, &nummodules, MAX_MODULES);

    if (reset && nummodules > 0)
    {
	/* Install firmware in all modules */
	serror = e1432_install(nummodules, LAs, 0, path);
	if (serror)
	    return err1432_to_PNP(serror);

	/* Get configuration of all modules */
	serror = e1432_get_hwconfig(nummodules, LAs, hwconfig);
	if (serror)
	    return err1432_to_PNP(serror);
    }

    return VI_SUCCESS;
}

ViStatus _VI_FUNC 
hpe1432_initC(ViRsrc rsrcName, ViBoolean id_query,
	      ViBoolean reset, ViPSession vi)
{
    SHORTSIZ16 serror;

#if 0
    /* This is how it should have been implemented.  But it wasn't,
       and now we may have users depending on us doing the preset even
       if the reset parameter is zero. */
    serror = e1432_assign_channels(nummodules, LAs, &semaID, reset);
    /* Return value checked below #if */

#else
    /* This seems wrong because it always reset the card even if the
       reset parameter was zero.  But that's what we shipped. */
    serror = e1432_assign_channel_numbers(nummodules, LAs, &semaID);

    /* If reset is not set, then hpe1432_initB didn't verify that
       sema.bin is installed, so there may be nothing there, so
       e1432_assign_channel_numbers may fail.  We shouldn't pass an
       error to the user in this case, because he's probably planning
       on downloading his own sema.bin.  Instead, try
       e1432_assign_channels with no preset, and see if that works. */
    if (!reset && serror < 0)
	serror = e1432_assign_channels(nummodules, LAs, &semaID,
				       reset);
#endif

    if(serror)
	return err1432_to_PNP(serror);
    *vi=(ViSession)i1432_get_sicl_id();

    return VI_SUCCESS;
}

ViStatus _VI_FUNC 
hpe1432_init(ViRsrc rsrcName, ViBoolean id_query,
			ViBoolean reset, ViPSession vi)
{
ViStatus vierr;

    vierr=hpe1432_initA(rsrcName, id_query, reset, vi);
    if(vierr)
	return vierr;

    vierr=hpe1432_initB(rsrcName, id_query, reset, vi);
    if(vierr)
	return vierr;

    vierr=hpe1432_initC(rsrcName, id_query, reset, vi);
    if(vierr)
	return vierr;

    return VI_SUCCESS;
}


#if 0  /* this is the original hpe1432_init() before splitting */


ViStatus _VI_FUNC 
hpe1432_init(ViRsrc rsrcName, ViBoolean id_query,
			ViBoolean reset, ViPSession vi)
{
SHORTSIZ16	serror;	/* e1432 error */
char		iface[15];  /* interface usually vxi */
int		i;	/* general loop index */

    *vi=VI_NULL;

    pnptracelevel=0;

    i_extract_interface(rsrcName,iface,15);

    serror=e1432_set_interface_addr(iface);
    if(serror)
	return err1432_to_PNP(serror);

    serror=e1432_init_io_driver();
    if(serror)
	return err1432_to_PNP(serror);

    /* get logical addresses */
    i_rsrc_to_array(rsrcName,LAs,&nummodules,MAX_MODULES);


    if((reset)&&(nummodules>0))
    {
        numToLoad=0;
        /* test each module for response to hwconfig */
        for(i=0;i<nummodules;i++)
        {
            serror=e1432_get_hwconfig(1,&(LAs[i]),&(hwconfig[i]));
            if(serror)
	    {
   	        loadLAs[numToLoad++]=LAs[i];
	    }
	}

	/* load sema.bin for modules desiring it */
        if(numToLoad>0)
        {
            serror=e1432_install(numToLoad, &(loadLAs[0]), 0, semabinloc);
    	    if(serror)
		return err1432_to_PNP(serror);
	}

        for(i=0;i<nummodules;i++)
        {
            serror=e1432_get_hwconfig(1,&(LAs[i]),&(hwconfig[i]));
    	    if(serror)
		return err1432_to_PNP(serror);
        }
    }

#if 0
    /* Preset the card if reset parameter is set */
    serror = e1432_assign_channels(nummodules, LAs, &semaID, reset);
#else
    /* Always presets the card regardless of reset parameter setting */
    serror = e1432_assign_channel_numbers(nummodules, LAs, &semaID);
#endif
    if(serror)
	return err1432_to_PNP(serror);
    *vi=(ViSession)i1432_get_sicl_id();

    return VI_SUCCESS;
}


#endif

ViStatus _VI_FUNC 
hpe1432_close(ViSession vi)
{
SHORTSIZ16	serror;	/* e1432 error */
ViStatus	perror;

#ifdef INSTR_CALLBACKS
    perror=vtl_remove_callbacks();
    /* keep going even if vtl_remove_callbacks fails */
#else
    perror=VI_SUCCESS;
#endif /* INSTR_CALLBACKS */

    serror=e1432_delete_all_chan_groups(semaID);
    semaID=0;
    if (serror)
	return err1432_to_PNP(serror);

    serror = e1432_uninit_io_driver();
    if (serror)
	return err1432_to_PNP(serror);

    return perror;
}


ViStatus _VI_FUNC 
hpe1432_reset(ViSession vi)
{
    return VI_ERROR_NIMPL_OPER;
}

ViStatus _VI_FUNC
hpe1432_getLockMode(ViSession vi, ViPInt32 mode)
{
    SHORTSIZ16 serror;
    int     imode;

    serror = i1432_visa_get_lock_mode(&imode);
    if (serror)
	return err1432_to_PNP(serror);
    *mode = imode;

    return VI_SUCCESS;
}

ViStatus _VI_FUNC
hpe1432_setLockMode(ViSession vi, ViInt32 mode)
{
    SHORTSIZ16 serror;

    serror = i1432_visa_set_lock_mode(mode);
    if (serror)
	return err1432_to_PNP(serror);

    return VI_SUCCESS;
}

static char *getteststring(SHORTSIZ16 e)
{
char *rv;
static char unk[30];

    switch(e)
    {
    case 0:
	rv= "PASS";
	break;

    case ERR1432_SELFTEST_DMA_TIMEOUT:
	rv= "ERR1432_SELFTEST_DMA_TIMEOUT";
	break;

    case ERR1432_SELFTEST_DRAM_SIZE:
	rv= "ERR1432_SELFTEST_DRAM_SIZE";
	break;

    case ERR1432_SELFTEST_DRAM:
	rv= "ERR1432_SELFTEST_DRAM";
	break;

    case ERR1432_SELFTEST_DRAM_FULL:
	rv= "ERR1432_SELFTEST_DRAM_FULL";
	break;

    case ERR1432_SELFTEST_YSRAM:
	rv= "ERR1432_SELFTEST_YSRAM";
	break;

    case ERR1432_SELFTEST_XIRAM:
	rv= "ERR1432_SELFTEST_XIRAM";
	break;

    case ERR1432_SELFTEST_XSRAM:
	rv= "ERR1432_SELFTEST_XSRAM";
	break;

    case ERR1432_SELFTEST_XSRAM2:
	rv= "ERR1432_SELFTEST_XSRAM2";
	break;

    case ERR1432_SELFTEST_XYSRAM:
	rv= "ERR1432_SELFTEST_XYSRAM";
	break;

    case ERR1432_SELFTEST_XYSRAM2:
	rv= "ERR1432_SELFTEST_XYSRAM2";
	break;

    case ERR1432_SELFTEST_TACH_ROLLOVER:
	rv= "ERR1432_SELFTEST_TACH_ROLLOVER";
	break;

    case ERR1432_SELFTEST_TACH_FULL:
	rv= "ERR1432_SELFTEST_TACH_FULL";
	break;

    case ERR1432_SELFTEST_TACH_EMPTY:
	rv= "ERR1432_SELFTEST_TACH_EMPTY";
	break;

    case ERR1432_SELFTEST_TACH_COUNT:
	rv= "ERR1432_SELFTEST_TACH_COUNT";
	break;

    case ERR1432_DIAG_ERR_UNDIAGNOSED:
	rv="ERR1432_DIAG_ERR_UNDIAGNOSED";
	break;

    case ERR1432_DIAG_ERR_SUBST:
	rv="ERR1432_DIAG_ERR_SUBST";
	break;

    case ERR1432_DIAG_ERR_DRAM:
	rv="ERR1432_DIAG_ERR_DRAM";
	break;

    case ERR1432_DIAG_ERR_TACH:
	rv="ERR1432_DIAG_ERR_TACH";
	break;

    case ERR1432_DIAG_ERR_SOURCE_FIT:
	rv="ERR1432_DIAG_ERR_SOURCE_FIT";
	break;

    case ERR1432_DIAG_ERR_SOURCE_SCA0:
	rv="ERR1432_DIAG_ERR_SOURCE_SCA0";
	break;

    case ERR1432_DIAG_ERR_SOURCE_SCA1:
	rv="ERR1432_DIAG_ERR_SOURCE_SCA1";
	break;

    case ERR1432_DIAG_ERR_INPUT_SCA0:
	rv="ERR1432_DIAG_ERR_INPUT_SCA0";
	break;

    case ERR1432_DIAG_ERR_INPUT_SCA1:
	rv="ERR1432_DIAG_ERR_INPUT_SCA1";
	break;

    case ERR1432_DIAG_ERR_INPUT_SCA2:
	rv="ERR1432_DIAG_ERR_INPUT_SCA2";
	break;

    case ERR1432_DIAG_ERR_INPUT_SCA3:
	rv="ERR1432_DIAG_ERR_INPUT_SCA3";
	break;

    default:
	sprintf(unk,"UNKNOWN ERROR %d",e);
	rv= unk;
	break;
    };

return rv;

}


ViStatus _VI_FUNC 
hpe1432_installFile(ViSession vi,ViPChar loc, ViInt32 fromMem)
{
SHORTSIZ16	serror; /* e1432 error */ 


    serror=e1432_install_file((const char *)loc, (SHORTSIZ16)fromMem);
    if(serror)
        return err1432_to_PNP(serror);

    return VI_SUCCESS;
}


ViStatus _VI_FUNC 
hpe1432_selftest(ViSession vi, ViPInt16 test_result, ViChar test_message[])
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_install_file(semabinloc, 0);
    if(serror)
        return err1432_to_PNP(serror);

    serror=0;
    if(nummodules>0)
    {
        serror=e1432_selftest(nummodules, LAs,E1432_SELFTEST_FULL,0);
        strcpy(test_message,getteststring(serror));
    }
    else
    {
	strcpy(test_message,"NO MODULES ARE OPEN");
    }
    *test_result=serror;

    return VI_SUCCESS;
}


ViStatus _VI_FUNC 
hpe1432_revision_query(ViSession vi, ViChar driver_rev[], ViChar instr_rev[])
{
char	ctmp[VI_FIND_BUFLEN];
extern char _e1432buildId1[];
extern char _e1432buildId2[];
char	*cptr;


    if(driver_rev)
    {
	*driver_rev='\0';
	/* find revision after ':' */
	cptr=strrchr(_e1432buildId1,':');
	if(cptr)
	    if(strlen(cptr)>1)
    	         strcpy(driver_rev,++cptr);
	/* find data after ',' */
	cptr=strrchr(_e1432buildId2,',');
	if(cptr)
	    if(strlen(cptr)>1)
		(void) strcat(driver_rev,cptr);
    }

    if(instr_rev)
    {
        ctmp[0]='\0';
        (void) sprintf(ctmp,"Hw:%ld,Bootrom:%ld,Firmware:%ld",
					hwconfig[0].hw_rev,
					hwconfig[0].bootrom_rev,
					hwconfig[0].fw_rev);
        strcpy(instr_rev,ctmp);
    }

    return VI_SUCCESS;
}


/* we can't query the hardware about errors, so this is unsupported */
ViStatus _VI_FUNC 
hpe1432_error_query(ViSession vi, ViPInt32 error, 
		  ViChar _VI_FAR error_message[])
{
    return VI_WARN_NSUP_ERROR_QUERY;
}


ViStatus _VI_FUNC 
hpe1432_error_message(ViSession vi, ViStatus error, ViChar _VI_FAR message[])
{
    if(!message)
       return(VI_ERROR_PARAMETER3);
    switch(error)
    {
	case VI_ERROR_PARAMETER1:
	    strcpy(message,"VI_ERROR_PARAMETER1");
	    break;

	case VI_ERROR_PARAMETER2:
	    strcpy(message,"VI_ERROR_PARAMETER2");
	    break;

	case VI_ERROR_PARAMETER3:
	    strcpy(message,"VI_ERROR_PARAMETER3");
	    break;

	case VI_ERROR_PARAMETER4:
	    strcpy(message,"VI_ERROR_PARAMETER4");
	    break;

	case VI_ERROR_PARAMETER5:
	    strcpy(message,"VI_ERROR_PARAMETER5");
	    break;

	case VI_ERROR_PARAMETER6:
	    strcpy(message,"VI_ERROR_PARAMETER6");
	    break;

	case VI_ERROR_PARAMETER7:
	    strcpy(message,"VI_ERROR_PARAMETER7");
	    break;

	case VI_ERROR_PARAMETER8:
	    strcpy(message,"VI_ERROR_PARAMETER8");
	    break;

	case VI_ERROR_CALIBRATION_FAILURE:
	    strcpy(message,"VI_ERROR_CALIBRATION_FAILURE");
	    break;

	case HPE1432_ERR_NULL_POINTER:
	    strcpy(message,"HPE1432_ERR_NULL_POINTER");
	    break;
	case HPE1432_ERR_TOO_MANY_CHANNELS:
	    strcpy(message,"HPE1432_ERR_TOO_MANY_CHANNELS");
	    break;

	case VI_ERROR_SYSTEM_ERROR       :
	    strcpy(message,"VI_ERROR_SYSTEM_ERROR");
	    break;

	case VI_ERROR_INV_OBJECT         :
	    strcpy(message,"VI_ERROR_INV_OBJECT");
	    break;

	case VI_ERROR_INV_EXPR           :
	    strcpy(message,"VI_ERROR_INV_EXPR");
	    break;

	case VI_ERROR_RSRC_NFOUND        :
	    strcpy(message,"VI_ERROR_RSRC_NFOUND");
	    break;

	case VI_ERROR_INV_RSRC_NAME      :
	    strcpy(message,"VI_ERROR_INV_RSRC_NAME");
	    break;

	case VI_ERROR_INV_ACC_MODE       :
	    strcpy(message,"VI_ERROR_INV_ACC_MODE");
	    break;

	case VI_ERROR_TMO                :
	    strcpy(message,"VI_ERROR_TMO");
	    break;

	case VI_ERROR_CLOSING_FAILED     :
	    strcpy(message,"VI_ERROR_CLOSING_FAILED");
	    break;

	case VI_ERROR_NSUP_ATTR          :
	    strcpy(message,"VI_ERROR_NSUP_ATTR");
	    break;

	case VI_ERROR_NSUP_ATTR_STATE    :
	    strcpy(message,"VI_ERROR_NSUP_ATTR_STATE");
	    break;

	case VI_ERROR_ATTR_READONLY      :
	    strcpy(message,"VI_ERROR_ATTR_READONLY");
	    break;

	case VI_ERROR_INV_EVENT          :
	    strcpy(message,"VI_ERROR_INV_EVENT");
	    break;

	case VI_ERROR_INV_MECH           :
	    strcpy(message,"VI_ERROR_INV_MECH");
	    break;

	case VI_ERROR_HNDLR_NINSTALLED   :
	    strcpy(message,"VI_ERROR_HNDLR_NINSTALLED");
	    break;

	case VI_ERROR_INV_HNDLR_REF      :
	    strcpy(message,"VI_ERROR_INV_HNDLR_REF");
	    break;

	case VI_ERROR_INV_CONTEXT        :
	    strcpy(message,"VI_ERROR_INV_CONTEXT");
	    break;

	case VI_ERROR_RAW_WR_PROT_VIOL   :
	    strcpy(message,"VI_ERROR_RAW_WR_PROT_VIOL");
	    break;

	case VI_ERROR_RAW_RD_PROT_VIOL   :
	    strcpy(message,"VI_ERROR_RAW_RD_PROT_VIOL");
	    break;

	case VI_ERROR_OUTP_PROT_VIOL     :
	    strcpy(message,"VI_ERROR_OUTP_PROT_VIOL");
	    break;

	case VI_ERROR_INP_PROT_VIOL      :
	    strcpy(message,"VI_ERROR_INP_PROT_VIOL");
	    break;

	case VI_ERROR_BERR               :
	    strcpy(message,"VI_ERROR_BERR");
	    break;

	case VI_ERROR_INV_SETUP          :
	    strcpy(message,"VI_ERROR_INV_SETUP");
	    break;

	case VI_ERROR_ALLOC              :
	    strcpy(message,"VI_ERROR_ALLOC");
	    break;

	case VI_ERROR_INV_MASK           :
	    strcpy(message,"VI_ERROR_INV_MASK");
	    break;

	case VI_ERROR_IO                 :
	    strcpy(message,"VI_ERROR_IO");
	    break;

	case VI_ERROR_INV_FMT            :
	    strcpy(message,"VI_ERROR_INV_FMT");
	    break;

	case VI_ERROR_NSUP_FMT           :
	    strcpy(message,"VI_ERROR_NSUP_FMT");
	    break;

	case VI_ERROR_LINE_IN_USE        :
	    strcpy(message,"VI_ERROR_LINE_IN_USE");
	    break;

	case VI_ERROR_SRQ_NOCCURRED      :
	    strcpy(message,"VI_ERROR_SRQ_NOCCURRED");
	    break;

	case VI_ERROR_INV_SPACE          :
	    strcpy(message,"VI_ERROR_INV_SPACE");
	    break;

	case VI_ERROR_INV_OFFSET         :
	    strcpy(message,"VI_ERROR_INV_OFFSET");
	    break;

	case VI_ERROR_NSUP_OFFSET        :
	    strcpy(message,"VI_ERROR_NSUP_OFFSET");
	    break;

	case VI_ERROR_WINDOW_NMAPPED     :
	    strcpy(message,"VI_ERROR_WINDOW_NMAPPED");
	    break;

	case VI_ERROR_NLISTENERS         :
	    strcpy(message,"VI_ERROR_NLISTENERS");
	    break;

	case VI_ERROR_NCIC               :
	    strcpy(message,"VI_ERROR_NCIC");
	    break;

	case VI_ERROR_NSUP_OPER          :
	    strcpy(message,"VI_ERROR_NSUP_OPER");
	    break;

	case VI_ERROR_NSUP_WIDTH         :
	    strcpy(message,"VI_ERROR_NSUP_WIDTH");
	    break;

	case VI_ERROR_INV_PROT           :
	    strcpy(message,"VI_ERROR_INV_PROT");
	    break;

	case VI_ERROR_INV_SIZE           :
	    strcpy(message,"VI_ERROR_INV_SIZE");
	    break;

	case VI_ERROR_WINDOW_MAPPED      :
	    strcpy(message,"VI_ERROR_WINDOW_MAPPED");
	    break;

	case VI_ERROR_NIMPL_OPER         :
	    strcpy(message,"VI_ERROR_NIMPL_OPER");
	    break;
	default:
	    (void) sprintf(message,"Unknown error number: %d\n",(int)error);
	break;
    }
    return VI_SUCCESS;
}

/********************************************************************/


/* Module setups */
ViStatus _VI_FUNC 
hpe1432_getAppendStatus(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_append_status(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setAppendStatus(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_append_status(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getArmChannel(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_arm_channel(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setArmChannel(ViSession vi, ViInt32 channel, ViInt32 active)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_arm_channel(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)active);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getArmChannelPerInput(ViSession vi, ViInt32 inchan, ViPInt32 viparm)
{
SHORTSIZ16    serror; /* e1432 error */
SHORTSIZ16    semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_arm_channel_per_input(semaID,(SHORTSIZ16)inchan,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_setArmChannelPerInput(ViSession vi, ViInt32 inchan, ViInt32 tachchan)
{
SHORTSIZ16    serror; /* e1432 error */

    serror=e1432_set_arm_channel_per_input(semaID,(SHORTSIZ16)inchan,
                                                      (SHORTSIZ16)tachchan);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getArmMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_arm_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setArmMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_arm_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getArmTimeInterval(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_arm_time_interval(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getArmTimeIntervalLimits(ViSession vi, ViInt32 channel, ViPReal64 min ,
		   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_arm_time_interval_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setArmTimeInterval(ViSession vi, ViInt32 channel, ViReal64 time)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_arm_time_interval(semaID, (SHORTSIZ16) channel,
					 (FLOATSIZ32) time);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getAutoTrigger(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_auto_trigger(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setAutoTrigger(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_auto_trigger(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getAvgMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_avg_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setAvgMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_avg_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getAvgNumber(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_avg_number(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getAvgNumberLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_avg_number_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setAvgNumber(ViSession vi, ViInt32 channel, ViInt32 num)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_avg_number(semaID,(SHORTSIZ16)channel,num);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getBlocksize(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_blocksize(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getBlocksizeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_blocksize_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setBlocksize(ViSession vi, ViInt32 channel, ViInt32 blocksize)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_blocksize(semaID,(SHORTSIZ16)channel,blocksize);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCalDac(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_cal_dac(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCalDacLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			 ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_cal_dac_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setCalDac(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_cal_dac(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCalVoltage(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_cal_voltage(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCalVoltageLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			     ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_cal_voltage_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setCalVoltage(ViSession vi, ViInt32 channel, ViReal64 volts)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_cal_voltage(semaID, (SHORTSIZ16) channel,
				   (FLOATSIZ32) volts);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCalin(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_calin(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setCalin(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_calin(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCenterFreq(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_center_freq(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getCenterFreqLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			     ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_center_freq_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setCenterFreq(ViSession vi, ViInt32 channel, ViReal64 freq)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_center_freq(semaID, (SHORTSIZ16) channel,
				   (FLOATSIZ32) freq);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getClockFreq(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_clock_freq(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getClockFreqLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			    ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_clock_freq_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setClockFreq(ViSession vi, ViInt32 channel, ViReal64 freq)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_clock_freq(semaID, (SHORTSIZ16) channel,
				  (FLOATSIZ32) freq);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getClockMaster(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_clock_master(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setClockMaster(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_clock_master(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getClockSource(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_clock_source(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setClockSource(ViSession vi, ViInt32 channel, ViInt32 source)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_clock_source(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)source);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDataMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_data_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setDataMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_data_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDataPort(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_data_port(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setDataPort(ViSession vi, ViInt32 channel, ViInt32 port)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_data_port(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)port);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDataSize(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_data_size(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setDataSize(ViSession vi, ViInt32 channel, ViInt32 size)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_data_size(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)size);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDecimationOutput(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_decimation_output(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setDecimationOutput(ViSession vi, ViInt32 channel, ViInt32 dec)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_decimation_output(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)dec);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDecimationOversample(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_decimation_oversample(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setDecimationOversample(ViSession vi, ViInt32 channel, ViInt32 sample)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_decimation_oversample(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)sample);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDeltaOrder(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_delta_order(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDeltaOrderLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_delta_order_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}



ViStatus _VI_FUNC 
hpe1432_setDeltaOrder(ViSession vi, ViInt32 channel, ViReal64 order)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_delta_order(semaID, (SHORTSIZ16) channel,
				   (FLOATSIZ32) order);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getFifoSizeCurrentMax(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_fifo_size_current_max(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getFifoSize(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_fifo_size(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getFifoSizeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_fifo_size_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setFifoSize(ViSession vi, ViInt32 channel, ViInt32 size)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_fifo_size(semaID,(SHORTSIZ16)channel,size);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getFilterSettlingTime(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_filter_settling_time(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getFilterSettlingTimeLimits(ViSession vi, ViInt32 channel,
				      ViPReal64 min, ViPReal64 max,
				      ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_filter_settling_time_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setFilterSettlingTime(ViSession vi, ViInt32 channel, ViReal64 time)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_filter_settling_time(semaID,(SHORTSIZ16)channel,(FLOATSIZ32)time);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getInternalDebug(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_internal_debug(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getInternalDebugLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
				ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_internal_debug_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setInternalDebug(ViSession vi, ViInt32 channel, ViInt32 debug)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_internal_debug(semaID, (SHORTSIZ16) channel, debug);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getInterruptMask(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_interrupt_mask(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC 
hpe1432_getInterruptReason (ViSession vi, ViInt32 chan, ViPInt32 reason)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	data;

    if(chan<1)
        return VI_ERROR_PARAMETER2;

    serror=e1432_read_register(semaID, (SHORTSIZ16)chan,
			       E1432_IRQ_STATUS2_REG, &data);

    *reason=(ViInt32)data;

    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_setInterruptMask(ViSession vi, ViInt32 channel, ViInt32 mask)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_interrupt_mask(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mask);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getInterruptPriority(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_interrupt_priority(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getInterruptPriorityLimits(ViSession vi, ViInt32 channel, 
			ViPReal64 min, ViPReal64 max, 
			ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_interrupt_priority_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setInterruptPriority(ViSession vi, ViInt32 channel, ViInt32 priority)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_interrupt_priority(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)priority);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getLbusMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_lbus_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setLbusMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_lbus_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC 
hpe1432_getMaxOrder(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_max_order(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getMaxOrderLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_max_order_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setMaxOrder(ViSession vi, ViInt32 channel, ViReal64 order)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_max_order(semaID, (SHORTSIZ16) channel,
				 (FLOATSIZ32) order);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getMeasTimeLength(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_meas_time_length(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getMeasTimeLengthLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_meas_time_length_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setMeasTimeLength(ViSession vi, ViInt32 channel, ViReal64 time)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_meas_time_length(semaID, (SHORTSIZ16) channel,
					(FLOATSIZ32) time);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getMultiSync(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_multi_sync(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setMultiSync(ViSession vi, ViInt32 channel, ViInt32 sync)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_multi_sync(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)sync);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCalcData(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_calc_data(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setCalcData(ViSession vi, ViInt32 channel, ViInt32 data)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_calc_data(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)data);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getOverlap(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_overlap(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getOverlapLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			 ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_overlap_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setOverlap(ViSession vi, ViInt32 channel, ViInt32 overlap)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_overlap(semaID,(SHORTSIZ16)channel,overlap);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getPreArmMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_pre_arm_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setPreArmMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_pre_arm_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getPreArmRpm(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_pre_arm_rpm(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getPreArmRpmLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_pre_arm_rpm_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setPreArmRpm(ViSession vi, ViInt32 channel, ViReal64 rpm)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_pre_arm_rpm(semaID, (SHORTSIZ16) channel,
				   (FLOATSIZ32) rpm);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRamp(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_ramp(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setRamp(ViSession vi, ViInt32 channel, ViInt32 ramp)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_ramp(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)ramp);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getLbusReset(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_lbus_reset(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_resetLbus(ViSession vi, ViInt32 channel, ViInt32 reset)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_reset_lbus(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)reset);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getSpan(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_span(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSpanLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_span_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setSpan(ViSession vi, ViInt32 channel, ViReal64 span)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_span(semaID,(SHORTSIZ16)channel,(FLOATSIZ32)span);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSumbus(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_sumbus(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setSumbus(ViSession vi, ViInt32 channel, ViInt32 sumbus)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_sumbus(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)sumbus);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggerDelay(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_trigger_delay(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggerDelayLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			       ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_trigger_delay_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setTriggerDelay(ViSession vi, ViInt32 channel, ViInt32 delay)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_trigger_delay(semaID,(SHORTSIZ16)channel,delay);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggerExt(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_trigger_ext(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTriggerExt(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_trigger_ext(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggersPerArm(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_triggers_per_arm(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggersPerArmLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			  ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_triggers_per_arm_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setTriggersPerArm(ViSession vi, ViInt32 channel, ViInt32 trigs)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_triggers_per_arm(semaID, (SHORTSIZ16) channel, trigs);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTtltrgClock(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_ttltrg_clock(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTtltrgClock(ViSession vi, ViInt32 channel, ViInt32 ttl)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_ttltrg_clock(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)ttl);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTtltrgGclock(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_ttltrg_gclock(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTtltrgGclock(ViSession vi, ViInt32 channel, ViInt32 ttl)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_ttltrg_gclock(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)ttl);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTtltrgSatrg(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_ttltrg_satrg(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTtltrgSatrg(ViSession vi, ViInt32 channel, ViInt32 ttl)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_ttltrg_satrg(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)ttl);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTtltrgTrigger(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_ttltrg_trigger(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTtltrgTrigger(ViSession vi, ViInt32 channel, ViInt32 ttl)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_ttltrg_trigger(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)ttl);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getUserDecimation(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
    SHORTSIZ16 serror; /* e1432 error */ 
    LONGSIZ32 semparm; /* semaphore parm */

    if (!viparm)
	return(VI_ERROR_PARAMETER3);

    serror = e1432_get_user_decimation(semaID, (SHORTSIZ16) channel, &semparm);
    *viparm = semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setUserDecimation(ViSession vi, ViInt32 channel, ViInt32 dec)
{
    SHORTSIZ16 serror; /* e1432 error */ 

    serror = e1432_set_user_decimation(semaID, (SHORTSIZ16) channel, dec);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getUserFramesPerBlock(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
    SHORTSIZ16 serror; /* e1432 error */ 
    LONGSIZ32 semparm; /* semaphore parm */

    if (!viparm)
	return(VI_ERROR_PARAMETER3);

    serror = e1432_get_user_frames_per_block(semaID,
					     (SHORTSIZ16) channel,
					     &semparm);
    *viparm = semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setUserFramesPerBlock(ViSession vi, ViInt32 channel, ViInt32 fpb)
{
    SHORTSIZ16 serror; /* e1432 error */ 

    serror = e1432_set_user_frames_per_block(semaID,
					     (SHORTSIZ16) channel,
					     fpb);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getWindow(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_window(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setWindow(ViSession vi, ViInt32 channel, ViInt32 window)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_window(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)window);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getZoom(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_zoom(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setZoom(ViSession vi, ViInt32 channel, ViInt32 zoom)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_zoom(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)zoom);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_writeSrcBufferData(ViSession vi, ViInt32 channel, ViPInt32 data,
			ViInt32 numwords, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 
    if(!data)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_write_srcbuffer_data(semaID,(SHORTSIZ16)channel,data,(LONGSIZ32)numwords,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getActive(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_active(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setActive(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_active(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getAmpScale(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_amp_scale(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getAmpScaleLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_amp_scale_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setAmpScale(ViSession vi, ViInt32 channel, ViReal64 scale)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_amp_scale(semaID, (SHORTSIZ16) channel,
				 (FLOATSIZ32) scale);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getAntiAliasAnalog(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_anti_alias_analog(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setAntiAliasAnalog(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_anti_alias_analog(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getAntiAliasDigital(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_anti_alias_digital(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setAntiAliasDigital(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_anti_alias_digital(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCoupling(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_coupling(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setCoupling(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_coupling(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getCurrentRpm(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_current_rpm(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getCvtData( ViSession vi, ViInt32 group, ViPReal64 buffer, ViInt32 size)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm[2 * E1432_ORDER_CVT_SIZE * E1432_INPUT_CHANS]; 
int i, nchan;
    serror=e1432_get_cvt_data(semaID, (SHORTSIZ16)group, semparm, (LONGSIZ32) size);
    if (serror)
	return err1432_to_PNP(serror);
    serror = i1432_get_id_nchan(semaID, (SHORTSIZ16) group, &nchan);
    if (serror)
	return err1432_to_PNP(serror);
    for (i = 0; i < size * nchan; i++)
	buffer[i] = (ViReal64)semparm[i];
    return VI_SUCCESS;
}


ViStatus _VI_FUNC 
hpe1432_getDataRpm(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_data_rpm(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDutyCycle(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_duty_cycle(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDutyCycleLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_duty_cycle_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setDutyCycle(ViSession vi, ViInt32 channel, ViReal64 duty)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_duty_cycle(semaID, (SHORTSIZ16) channel,
				  (FLOATSIZ32) duty);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getFilterFreq(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_filter_freq(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getFilterFreqLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			     ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_filter_freq_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setFilterFreq(ViSession vi, ViInt32 channel, ViReal64 freq)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_filter_freq(semaID, (SHORTSIZ16) channel,
				   (FLOATSIZ32) freq);
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_getInputLow  (ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_input_low(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC 
hpe1432_setInputLow(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_input_low(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC 
hpe1432_getInputHigh(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_input_high(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setInputHigh(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_input_high(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getInputMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_input_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setInputMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_input_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getNextArmRpm(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_next_arm_rpm(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRpmHigh(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_rpm_high(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRpmHighLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_rpm_high_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setRpmHigh(ViSession vi, ViInt32 channel, ViReal64 rpm)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_rpm_high(semaID, (SHORTSIZ16) channel,
				(FLOATSIZ32) rpm);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRpmInterval(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_rpm_interval(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRpmIntervalLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_rpm_interval_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setRpmInterval(ViSession vi, ViInt32 channel, ViReal64 rpm)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_rpm_interval(semaID, (SHORTSIZ16) channel,
				    (FLOATSIZ32) rpm);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRpmLow(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_rpm_low(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRpmLowLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_rpm_low_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setRpmLow(ViSession vi, ViInt32 channel, ViReal64 rpm)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_rpm_low(semaID, (SHORTSIZ16) channel,
			       (FLOATSIZ32) rpm);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRpmSmoothing(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_rpm_smoothing(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRpmSmoothingLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_rpm_smoothing_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setRpmSmoothing(ViSession vi, ViInt32 channel, ViReal64 rpm)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_rpm_smoothing(semaID, (SHORTSIZ16) channel,
				     (FLOATSIZ32) rpm);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachPpr(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_tach_ppr(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachPprLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			  ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_tach_ppr_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setTachPpr(ViSession vi, ViInt32 channel, ViReal64 ppr)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_tach_ppr(semaID, (SHORTSIZ16) channel,
				(FLOATSIZ32) ppr);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachClockFreq(ViSession vi, ViInt32 channel, ViPReal64 rate)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_tach_clock_freq(semaID,(SHORTSIZ16)channel,&r);
    *rate=r;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getRawTachs( ViSession vi, ViInt32 group, 
		     ViPInt32 buffer, ViInt32 size, ViPInt32 actualCnt)
{
SHORTSIZ16	serror; /* e1432 error */ 
    serror=e1432_get_raw_tachs(semaID, (SHORTSIZ16)group, 
		    (unsigned long *)buffer,
		    (LONGSIZ32)size, (LONGSIZ32 *) actualCnt);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getRampRate(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_ramp_rate(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getRampRateLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_ramp_rate_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setRampRate(ViSession vi, ViInt32 channel, ViReal64 rate)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_ramp_rate(semaID, (SHORTSIZ16) channel,
				 (FLOATSIZ32) rate);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRange(ViSession vi, ViInt32 channel, ViPReal64 rate)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_range(semaID,(SHORTSIZ16)channel,&r);
    *rate=r;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRangeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		       ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_range_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setRange(ViSession vi, ViInt32 channel, ViReal64 range)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_range(semaID, (SHORTSIZ16) channel,
			     (FLOATSIZ32) range);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRangeCharge(ViSession vi, ViInt32 channel, ViPReal64 rate)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_range_charge(semaID,(SHORTSIZ16)channel,&r);
    *rate=r;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRangeChargeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		       ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_range_charge_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setRangeCharge(ViSession vi, ViInt32 channel, ViReal64 range)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_range_charge(semaID, (SHORTSIZ16) channel,
				    (FLOATSIZ32) range);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRangeMike(ViSession vi, ViInt32 channel, ViPReal64 rate)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_range_mike(semaID,(SHORTSIZ16)channel,&r);
    *rate=r;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRangeMikeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		       ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_range_mike_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setRangeMike(ViSession vi, ViInt32 channel, ViReal64 range)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_range_mike(semaID, (SHORTSIZ16) channel,
				  (FLOATSIZ32) range);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSineFreq(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_sine_freq(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSineFreqLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_sine_freq_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setSineFreq(ViSession vi, ViInt32 channel, ViReal64 freq)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_sine_freq(semaID, (SHORTSIZ16) channel,
				 (FLOATSIZ32) freq);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSinePhase(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_sine_phase(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSinePhaseLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			    ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_sine_phase_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setSinePhase(ViSession vi, ViInt32 channel, ViReal64 phase)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_sine_phase(semaID, (SHORTSIZ16) channel,
				  (FLOATSIZ32) phase);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceBlocksize(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_source_blocksize(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceBlocksizeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			  ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_source_blocksize_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setSourceBlocksize(ViSession vi, ViInt32 channel, ViInt32 blocksize)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_source_blocksize(semaID,(SHORTSIZ16)channel,blocksize);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceCenterFreq(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_source_centerfreq(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceCenterFreqLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			 ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_source_centerfreq_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setSourceCenterFreq(ViSession vi, ViInt32 channel, ViReal64 freq)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_source_centerfreq(semaID, (SHORTSIZ16) channel,
					 (FLOATSIZ32) freq);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceCola(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_source_cola(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setSourceCola(ViSession vi, ViInt32 channel, ViInt32 cola)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_source_cola(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)cola);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_source_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setSourceMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_source_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceOutput(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_source_output(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setSourceOutput(ViSession vi, ViInt32 channel, ViInt32 output)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_source_output(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)output);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceSeed(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_source_seed(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceSeedLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			     ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_source_seed_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setSourceSeed(ViSession vi, ViInt32 channel, ViInt32 seed)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_source_seed(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)seed);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceSpan(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_source_span(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceSpanLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			     ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_source_span_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setSourceSpan(ViSession vi, ViInt32 channel, ViReal64 span)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_source_span(semaID, (SHORTSIZ16) channel,
				   (FLOATSIZ32) span);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSourceSum(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_source_sum(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setSourceSum(ViSession vi, ViInt32 channel, ViInt32 sum)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_source_sum(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)sum);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSrcBufferSize(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_srcbuffer_size(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSrcBufferSizeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
				ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_srcbuffer_size_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setSrcBufferSize(ViSession vi, ViInt32 channel, ViInt32 size)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_srcbuffer_size(semaID,(SHORTSIZ16)channel,size);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSrcBufferMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_srcbuffer_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setSrcBufferMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

   serror=e1432_set_srcbuffer_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
   return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getSrcBufferInit(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_srcbuffer_init(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setSrcBufferInit(ViSession vi, ViInt32 channel, ViInt32 init)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_srcbuffer_init(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)init);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_checkSrcArbRdy  (ViSession vi, ViInt32 group, ViInt32 mode, ViPInt32 srcArbRdy)
{
SHORTSIZ16	rv;

    rv=e1432_check_src_arbrdy(semaID, (SHORTSIZ16)group,
				       (SHORTSIZ16)mode);
    *srcArbRdy=(ViInt32)rv;
    return(VI_SUCCESS);
}

ViStatus _VI_FUNC
hpe1432_checkSrcOverload  (ViSession vi, ViInt32 group, ViPInt32 srcOverload)
{
SHORTSIZ16	rv; /* e1432 error */ 

    rv=e1432_check_src_overload(semaID, (SHORTSIZ16)group);
    *srcOverload=rv;
    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_checkSrcOverread  (ViSession vi, ViInt32 group, ViPInt32 srcOverread)
{
SHORTSIZ16	rv;

    rv=e1432_check_src_overread(semaID, (SHORTSIZ16)group);
    *srcOverread=rv;
    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_checkSrcUnderrun  (ViSession vi, ViInt32 group, ViPInt32 srcUnderrun)
{
SHORTSIZ16	rv;

    rv=e1432_check_src_underrun(semaID, (SHORTSIZ16)group);
    *srcUnderrun=rv;
    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_checkSrcShutdown  (ViSession vi, ViInt32 group, ViPInt32 srcShutdown)
{
SHORTSIZ16	rv;

    rv=e1432_check_src_shutdown(semaID, (SHORTSIZ16)group);
    *srcShutdown=rv;
    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_getSrcArbStates  (ViSession vi, ViInt32 group, ViPInt32 xfrBufWds,
			  ViPInt32 srcBufStateAB, ViPInt32 srcBufStateA,
			  ViPInt32 srcBufStateB)
{

    e1432_get_src_arbstates(semaID, (SHORTSIZ16)group, xfrBufWds,
			    srcBufStateAB, srcBufStateA, srcBufStateB);
    return(VI_SUCCESS);
}



ViStatus _VI_FUNC 
hpe1432_getTachDecimate(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_tach_decimate(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachDecimateLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			       ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_tach_decimate_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setTachDecimate(ViSession vi, ViInt32 channel, ViInt32 decimate)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_tach_decimate(semaID, (SHORTSIZ16) channel, decimate);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachHoldoff(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_tach_holdoff(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachIrqNumber(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_tach_irq_number(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachIrqNumberLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			       ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_tach_irq_number_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setTachIrqNumber(ViSession vi, ViInt32 channel, ViInt32 num)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_tach_irq_number(semaID,(SHORTSIZ16)channel,(LONGSIZ32)num);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getTachHoldoffLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_tach_holdoff_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setTachHoldoff(ViSession vi, ViInt32 channel, ViReal64 holdoff)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_tach_holdoff(semaID, (SHORTSIZ16) channel,
				    (FLOATSIZ32) holdoff);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachMaxTime(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_tach_max_time(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTachMaxTimeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_tach_max_time_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setTachMaxTime(ViSession vi, ViInt32 channel, ViReal64 time)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_tach_max_time(semaID, (SHORTSIZ16) channel,
				     (FLOATSIZ32) time);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggerChannel(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_trigger_channel(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTriggerChannel(ViSession vi, ViInt32 channel, ViInt32 status)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_trigger_channel(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)status);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggerLevel(ViSession vi, ViInt32 channel, ViInt32 select,
				ViPReal64 level)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	mylevel;

    serror=e1432_get_trigger_level(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)select,&mylevel);
    *level=(ViReal64)mylevel;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggerLevelLimits(ViSession vi, ViInt32 channel, ViInt32 select,
				ViPReal64 min, ViPReal64 max,
				ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_trigger_level_limits(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)select,
				          &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);

}


ViStatus _VI_FUNC 
hpe1432_setTriggerLevel(ViSession vi, ViInt32 channel, ViInt32 select,
				ViReal64 level)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_trigger_level(semaID, (SHORTSIZ16) channel,
				     (SHORTSIZ16) select,
				     (FLOATSIZ32) level);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggerSlope(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_trigger_slope(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTriggerSlope(ViSession vi, ViInt32 channel, ViInt32 slope)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_trigger_slope(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)slope);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTriggerMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_trigger_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTriggerMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_trigger_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}



/* Short cuts */
ViStatus _VI_FUNC 
hpe1432_preset(ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_preset(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setAnalogInput(ViSession vi, ViInt32 channel, ViInt32 mode,
			ViInt32 source, ViInt32 state ,
			ViInt32 coupling, ViReal64 range)
{
    ViStatus error;

    error = hpe1432_setInputMode(vi, channel, mode);
    if (error != VI_SUCCESS)
	return error;

    error = hpe1432_setInputHigh(vi, channel, source);
    if (error != VI_SUCCESS)
	return error;

    error = hpe1432_setAntiAliasAnalog(vi, channel, state);
    if (error != VI_SUCCESS)
	return error;

    error = hpe1432_setCoupling(vi, channel, coupling);
    if (error != VI_SUCCESS)
	return error;

    error = hpe1432_setRange(vi, channel, range);
    if (error != VI_SUCCESS)
	return error;

    return VI_SUCCESS;
}


ViStatus _VI_FUNC 
hpe1432_setDataFormat(ViSession vi, ViInt32 channel, ViInt32 blocksize,
		      ViInt32 datasize, ViInt32 mode, ViInt32 append)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_data_format(semaID,(SHORTSIZ16)channel,(LONGSIZ32)blocksize,(SHORTSIZ16)datasize,(SHORTSIZ16)mode,(SHORTSIZ16)append);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setInterrupt(ViSession vi, ViInt32 channel, ViInt32 priority,
			ViInt32 mask)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_interrupt(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)priority,(SHORTSIZ16)mask);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTrigger(ViSession vi, ViInt32 channel, ViInt32 state,
			ViInt32 delay, ViReal64 level0, ViReal64 level1,
			ViInt32 slope, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_trigger(semaID, (SHORTSIZ16) channel,
			       (SHORTSIZ16) state, (LONGSIZ32) delay,
			       (FLOATSIZ32) level0, (FLOATSIZ32) level1,
			       (SHORTSIZ16) slope, (SHORTSIZ16) mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getTtltrgLines(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_ttltrg_lines(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTtltrgLines(ViSession vi, ViInt32 channel, ViInt32 ttl)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_ttltrg_lines(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)ttl);
    return err1432_to_PNP(serror);
}



/* Group setups */

ViStatus _VI_FUNC 
hpe1432_createChannelGroup(ViSession vi, ViInt32 num, ViInt32 channels[],
			ViPInt32 groupID)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	*channellist;
int		i;


    if(!groupID)
       return(HPE1432_ERR_NULL_POINTER);
    if(num>0 && !channels)
       return(HPE1432_ERR_NULL_POINTER);
    if((num<0)||(num>2048)) /* rational check */
    {
#if 0
printf("num=%d\n",num);
#endif
       return(VI_ERROR_PARAMETER2);
    }

    if(num > 0)   /* num == 0 creates empty channel group which is legal. */
    {
       channellist=(SHORTSIZ16 *)malloc(num*sizeof(SHORTSIZ16));
       if(!channellist)
          return(HPE1432_ERR_NULL_POINTER);

       /* convert from int32 to int16 for e1432 library */
       for(i=0;i<num;i++)
   	  channellist[i] = (SHORTSIZ16) channels[i];
    }
    else channellist = NULL;

    serror=e1432_create_channel_group(semaID,(SHORTSIZ16)num,channellist);
    if(serror<0)
    { /* good group ID */
	*groupID=serror;
	serror=0;
    }
    else
    {
	*groupID=0;
	serror=-serror;  /* e1432 negates error for this call */
    }

    if(channellist) /* check perhaps not needed, but lets be safe */
       free(channellist);
    
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_getGroupInfo  (ViSession vi, ViInt32 group, ViInt32 select,
		       ViPInt32 answer, ViInt32 size)
{
    ViInt32 i;
    SHORTSIZ16 serror;
/* try not to over allocate stack space */

    if(size<100)
    {
	SHORTSIZ16 sans[100];
	for(i=0;i<size;i++)
	    answer[i]=0;
	serror=e1432_get_group_info(semaID,(SHORTSIZ16)group,(SHORTSIZ16)select,sans,(SHORTSIZ16)size);
	if(!serror)
	{
	    for(i=0;i<size;i++)
		answer[i]=(ViInt32)sans[i];
	}
    }
    else if(size<1000)
    {
	SHORTSIZ16 sans[1000];
	for(i=0;i<size;i++)
	    answer[i]=0;
	serror=e1432_get_group_info(semaID,(SHORTSIZ16)group,(SHORTSIZ16)select,sans,(SHORTSIZ16)size);
	if(!serror)
	{
	    for(i=0;i<size;i++)
		answer[i]=(ViInt32)sans[i];
	}
    }
    else if(size<2500)
    {
	SHORTSIZ16 sans[2500];
	for(i=0;i<size;i++)
	    answer[i]=0;
	serror=e1432_get_group_info(semaID,(SHORTSIZ16)group,(SHORTSIZ16)select,sans,(SHORTSIZ16)size);
	if(!serror)
	{
	    for(i=0;i<size;i++)
		answer[i]=(ViInt32)sans[i];
	}
    }
    else
        return VI_ERROR_PARAMETER5;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_deleteAllChanGroups(ViSession vi)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_delete_all_chan_groups(semaID);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_deleteChannelGroup(ViSession vi, ViInt32 group)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_delete_channel_group(semaID,(SHORTSIZ16)group);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getNumChans(ViSession vi, ViPInt32 totalChans, ViPInt32 numInputs,
		    ViPInt32 numSources, ViPInt32 numTachs)
{
int	i;
ViInt32	chans=0;
ViInt32	inputs=0;
ViInt32	sources=0;
ViInt32	tachs=0;

    for(i=0;i<nummodules;i++)
    {
	chans   += hwconfig[i].total_chans;
	inputs  += hwconfig[i].input_chans;
	sources += hwconfig[i].source_chans;
	tachs   += hwconfig[i].tach_chans;
    }

    if(totalChans)
	*totalChans=chans;
    if(numInputs)
       *numInputs=inputs;
    if(numSources)
       *numSources=sources;
    if(numTachs)
       *numTachs=tachs;

    return VI_SUCCESS;
}


ViStatus _VI_FUNC 
hpe1432_getAutoGroupMeas(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_auto_group_meas(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setAutoGroupMeas(ViSession vi, ViInt32 channel, ViInt32 state)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_auto_group_meas(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)state);
    return err1432_to_PNP(serror);
}


/* Actions */
ViStatus _VI_FUNC 
hpe1432_armMeasure(ViSession vi, ViInt32 channel, ViInt32 wait)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_arm_measure(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)wait);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_armMeasureMasterFinish  (ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_arm_measure_master_finish(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_armMeasureMasterSetup  (ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_arm_measure_master_setup(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_armMeasureSlaveFinish  (ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_arm_measure_slave_finish(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_autoRange( ViSession vi, ViInt32 group, ViReal64 autoRangeTime)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_auto_range(semaID,(SHORTSIZ16)group,(FLOATSIZ64)autoRangeTime);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_autoZero(ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_auto_zero(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_finishMeasure(ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_finish_measure(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_initMeasure(ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_init_measure(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_initMeasureFinish(ViSession vi, ViInt32 channel, ViInt32 wait)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_init_measure_finish(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)wait);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_initMeasureToBooted(ViSession vi, ViInt32 channel, ViInt32 wait)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_init_measure_to_booted(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)wait);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_preArmMeasure(ViSession vi, ViInt32 channel, ViInt32 wait)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_pre_arm_measure(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)wait);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_reenableInterrupt(ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_reenable_interrupt(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_resetMeasure(ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_reset_measure(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_sendTrigger(ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_send_trigger(semaID,(SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getTriggerMaster(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_trigger_master(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setTriggerMaster(ViSession vi, ViInt32 channel, ViInt32 state)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_trigger_master(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)state);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_triggerMeasure(ViSession vi, ViInt32 channel, ViInt32 wait)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_trigger_measure(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)wait);
    return err1432_to_PNP(serror);
}



/* Results */
ViStatus _VI_FUNC 
hpe1432_checkOverloads(ViSession vi, ViInt32 channel, ViPInt16 any,
		      ViPInt16 common, ViPInt16 diff, ViPInt16 half)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_check_overloads(semaID, (SHORTSIZ16)channel, any,
                                 common, diff, half);
    return err1432_to_PNP(serror);

}


ViStatus _VI_FUNC 
hpe1432_readRawData(ViSession vi, ViInt32 channel, ViInt32 which, 
			ViChar data[], ViInt32 size, ViPInt32 actualCnt,
			ViInt32 wait)
{
SHORTSIZ16	serror; /* e1432 error */ 
ViInt32	flag;
ViStatus status;


    if(!data)
       return(HPE1432_ERR_NULL_POINTER);
    if(!actualCnt)
       return(HPE1432_ERR_NULL_POINTER);

    if(wait)
    do
    {
        status=hpe1432_blockAvailable(vi, channel, &flag);
        if(status) return status;
	/* wait a bit for things to percolate */
	if(!flag)
	    i1432_pause(0.01);
    } while (!flag);

    serror=e1432_read_raw_data(semaID,(SHORTSIZ16)channel,
				   (SHORTSIZ16)which,
				   data,
				   size,
				   &last_trailer,
				   actualCnt);
    return err1432_to_PNP(serror);
}


#ifdef INSTR_REAL32

/*                   !!!!!!!!! NOTE !!!!!!!!!!!!!                          */
/* define INSTR_REAL32 before including hpe1432.h to get the function      */ 
/* prototype for this hpe1432_readFloat32Data                              */
/*                                                                         */
/* WHY? you ask... The type ViReal32 is not an allowed VXI Plug&Play       */
/* data type.  See VPP-3.4 Revision 2.1, Feb 2 1996, Table 3-1, page 3-11  */
/* So you need to compile with the define INSTR_REAL32 to get              */
/* hpe1432_readFloat32Data()                                               */


ViStatus _VI_FUNC 
hpe1432_readFloat32Data(ViSession vi, ViInt32 channel, ViInt32 which,
		ViPReal32 data, ViInt32 size, ViPInt32 actualCnt, ViInt32 wait)
{
SHORTSIZ16	serror; /* e1432 error */ 
ViInt32	flag;
ViStatus status;


    if(!data)
       return(HPE1432_ERR_NULL_POINTER);
    if(!actualCnt)
       return(HPE1432_ERR_NULL_POINTER);

    if(wait)
    do
    {
        status=hpe1432_blockAvailable(vi, channel, &flag);
        if(status) return status;
	/* wait a bit for things to percolate */
	if(!flag)
	    i1432_pause(0.01);
    } while (!flag);

    serror=e1432_read_float32_data(semaID,(SHORTSIZ16)channel,
				   (SHORTSIZ16)which,
				   data,
				   size,
				   &last_trailer,
				   actualCnt);
    return err1432_to_PNP(serror);
}
#endif


ViStatus _VI_FUNC 
hpe1432_readFloat64Data(ViSession vi, ViInt32 channel, ViInt32 which,
		ViPReal64 data, ViInt32 size, ViPInt32 actualCnt, ViInt32 wait)
{
SHORTSIZ16	serror; /* e1432 error */ 
ViInt32	flag;
ViStatus status;


    if(!data)
       return(HPE1432_ERR_NULL_POINTER);
    if(!actualCnt)
       return(HPE1432_ERR_NULL_POINTER);

    if(wait)
    do
    {
        status=hpe1432_blockAvailable(vi, channel, &flag);
        if(status) return status;
	/* wait a bit for things to percolate */
	if(!flag)
	    i1432_pause(0.01);
    } while (!flag);

    serror=e1432_read_float64_data(semaID,(SHORTSIZ16)channel,
				   (SHORTSIZ16)which,
				   data,
				   size,
				   &last_trailer,
				   actualCnt);
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC 
hpe1432_readTrailerData(ViSession vi, ViPReal64 trig, ViPReal64 zoom,
			ViPReal64 rpm1, ViPReal64 rpm2, ViPInt32 gap,
			ViPInt32 info, ViPReal64 peak, ViPReal64 rms)
{
    if(trig)
	*trig=last_trailer.trig_corr;
    if(zoom)
	*zoom=last_trailer.zoom_corr;
    if(rpm1)
	*rpm1=last_trailer.rpm1;
    if(rpm2)
	*rpm2=last_trailer.rpm2;
    if(gap)
	*gap=last_trailer.gap;
    if(info)
	*info=last_trailer.info;
    if(peak)
	*peak=last_trailer.peak;
    if(rms)
	*rms=last_trailer.rms;
    return VI_SUCCESS;

}




/* General inquiry */
ViStatus _VI_FUNC 
hpe1432_blockAvailable(ViSession vi, ViInt32 channel, ViPInt32 flag)
{
SHORTSIZ16	serror; /* e1432 error */ 

    if(!flag)
       return(HPE1432_ERR_NULL_POINTER);

    serror=e1432_block_available(semaID,(SHORTSIZ16)channel);
    if(serror>0)
    { 
	*flag=1;
	serror=0;
    }
    else if(serror==ERR1432_FIFO_OVERRUN)
    {
	*flag= -1;
	serror=0;
    }
    else if(serror==ERR1432_TACH_BUFFER_OVERFLOW)
    {
	*flag= -2;
	serror=0;
    }
    else 
    {
	*flag=0;
    }

    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getDecimation(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_decimation(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getMeasState(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_meas_state(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getScale(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ64	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_scale(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}




ViStatus _VI_FUNC
hpe1432_errorDetails(ViSession vi, ViChar error[], ViInt32 errLen)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	dontcare;

    serror=e1432_fill_error_string(error, (SHORTSIZ16)errLen, &dontcare);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_errorDetails2(ViSession vi, ViChar error[], ViInt32 errLen,
		      ViPInt32 actual)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	sactual;

    serror=e1432_fill_error_string(error, (SHORTSIZ16)errLen, &sactual);
    *actual = sactual;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_install(ViSession vi, ViInt32 numMods, ViInt32 LAs[], ViString file)
{
ViInt16	sLAs[MAX_MODULES];
ViInt32	i;
SHORTSIZ16	serror; /* e1432 error */ 

    /* error if too many modules */
    if(numMods>MAX_MODULES)
	return(VI_ERROR_PARAMETER2);

    /* copy LAs to our int16 array */
    for(i=0;i<numMods;i++)
	sLAs[i]=(ViInt16)LAs[i];

    serror=e1432_install((SHORTSIZ16)numMods, sLAs, 0, file);
    if(serror)
        return err1432_to_PNP(serror);

    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_cachedParmUpdate(ViSession vi, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_cached_parm_update(semaID, (SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getCouplingFreq(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_coupling_freq(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getCouplingFreqLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_coupling_freq_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_setCouplingFreq(ViSession vi,ViInt32 channel, ViReal64 couplingFreq)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_coupling_freq(semaID, (SHORTSIZ16) channel,
				     (FLOATSIZ32) couplingFreq);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getWeighting(ViSession vi,ViInt32 channel, ViPInt32  viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_weighting(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_setWeighting(ViSession vi,ViInt32 channel, ViInt32 weight)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_weighting(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)weight);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_sendTachs(ViSession vi,ViInt32 group, ViInt32 tach,
		  ViInt32 tachBuffer[], ViInt32 bufSize, ViPInt32 count)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_send_tachs(semaID,(SHORTSIZ16)group,(SHORTSIZ16)tach,
			    (ViUInt32 *)tachBuffer, bufSize, count);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getTachDelay(ViSession vi,ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_tach_delay(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getInputOffset(ViSession vi,ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_input_offset(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getInputOffsetLimits(ViSession vi,ViInt32 channel, ViPReal64 min,
			     ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_input_offset_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_setInputOffset(ViSession vi,ViInt32 channel, ViReal64 inputOffset)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_input_offset(semaID, (SHORTSIZ16) channel,
				    (FLOATSIZ32) inputOffset);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getEnable(ViSession vi,ViInt32 channel, ViInt32 dataType,
		  ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_enable(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)dataType,
			    &semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_setEnable(ViSession vi,ViInt32 channel, ViInt32 dataType,
		  ViInt32 enable)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_enable(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)dataType,
			    (SHORTSIZ16)enable);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getAutoZeroOffset(ViSession vi,ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_autozero_offset(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getAutoZeroOffsetLimits(ViSession vi,ViInt32 channel, ViPReal64 min,
				 ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_autozero_offset_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_setAutoZeroOffset(ViSession vi,ViInt32 channel, ViReal64 azOffset)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror = e1432_set_autozero_offset(semaID, (SHORTSIZ16) channel,
				       (FLOATSIZ32) azOffset);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getSrcArbstates(ViSession vi,ViInt32 channel, ViPInt32 xfrbuf_wds,
			ViPInt32 srcbuf_state_AB, ViPInt32 srcbuf_state_A,
			ViPInt32 srcbuf_state_B)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_src_arbstates(semaID,(SHORTSIZ16)channel,
                                   xfrbuf_wds,
				   srcbuf_state_AB,
				   srcbuf_state_A,
				   srcbuf_state_B);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getMeasWarning(ViSession vi,ViInt32 channel, ViInt16 warnings[],
		       ViInt32 bufferSize, ViPInt32 count)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_meas_warning(semaID,(SHORTSIZ16)channel,warnings,
				  bufferSize,(ViPUInt32)count);
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_getMeasWarningString  (ViSession vi, ViChar warningString[],
			       ViInt32 bufferSize, ViInt32 warning)
{
vi=vi;

    (void) strncpy(warningString,
		   e1432_get_warning_string((SHORTSIZ16)warning),
		   bufferSize);

    return VI_SUCCESS;
}


ViStatus _VI_FUNC hpe1432_find  (ViSession vi, 
				 ViInt32 addList[], ViInt32 listSize,
				 ViPInt32 numFound,
				 ViChar rsrc[], ViInt32 rsrcLen)
{
#ifdef HAVE_VTL  /* only coded for VTL */

    return(i1432_find_modules(addList,listSize,numFound,rsrc,rsrcLen));
#else
    return VI_ERROR_NIMPL_OPER;
#endif
}


ViStatus _VI_FUNC
hpe1432_getBlocksizeCurrentMax  (ViSession vi, ViInt32 group,
                                 ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_blocksize_current_max(semaID,(SHORTSIZ16)group,viparm);
    return err1432_to_PNP(serror);
}

#define MAX_ARRAY_CONTROL_CHANS 200
#define ARRAY_CONTROL_ELEMENTS 6 /* number of control elements in array */

/* these are used for the array control functions */
static ViInt32 arraygroupid;
static ViInt32 arraychanlist[MAX_ARRAY_CONTROL_CHANS];
static ViInt32 arrayblocksize[MAX_ARRAY_CONTROL_CHANS];
static ViInt32 arrayindex;
static ViInt32 arraynumchans;


ViStatus _VI_FUNC
hpe1432_arrayControl(ViSession vi, ViInt32 numChans, ViReal64 array[])
{
ViStatus	vierr;
ViInt32		i;
ViInt32		lastchan;
ViInt32		chan;
ViReal64	range;
ViReal64	span;
ViInt32		blocksize;
ViInt32		inputmode;
ViStatus 	coupling;


    if((numChans<1)||(numChans>MAX_ARRAY_CONTROL_CHANS))
	return(VI_ERROR_PARAMETER2);

    /* signal no data */
    arrayindex=0;

    arraynumchans=numChans;
    /* check array data for validity and build chan list */
    lastchan=0;
    for(i=0;i<numChans;i++)
    {
	chan = (ViInt32) (array[i * ARRAY_CONTROL_ELEMENTS + 0] + 0.1);

 	/* check chan */
	if(chan<=lastchan)
	    return(VI_ERROR_PARAMETER3);
	arraychanlist[i]=chan;
	lastchan=chan;
    }

    /* delete old arraygroupid and make a group  */
    if(arraygroupid)
    {
	vierr=hpe1432_deleteChannelGroup(vi, arraygroupid);
	if(vierr)
	    return vierr;
    }

    vierr=hpe1432_createChannelGroup(vi,numChans,arraychanlist,&arraygroupid);
    if(vierr)
	return vierr;
    if(arraygroupid>=0)
	return VI_ERROR_PARAMETER3;
	
    /* set each channel */
    for(i=0;i<numChans;i++)
    {
	chan =      (ViInt32) (array[i * ARRAY_CONTROL_ELEMENTS + 0] + 0.1);
	range =                array[i * ARRAY_CONTROL_ELEMENTS + 1];
	span =                 array[i * ARRAY_CONTROL_ELEMENTS + 2];
	blocksize = (ViInt32) (array[i * ARRAY_CONTROL_ELEMENTS + 3] + 0.1);
	inputmode = (ViInt32) (array[i * ARRAY_CONTROL_ELEMENTS + 4] + 0.1);
	coupling = (ViStatus) (array[i * ARRAY_CONTROL_ELEMENTS + 5] + 0.1);

	/* convert 0s to defaults */

	if(inputmode<1)
	    inputmode=HPE1432_INPUT_MODE_VOLT;

	if(coupling<1)
	    coupling=E1432_COUPLING_DC;

        /* save data we care about */
	arrayblocksize[i]=blocksize;

	/* tell the hardware */
	vierr=hpe1432_setRange(vi, chan, range);
        if(vierr)
	    return vierr;
	    
	vierr=hpe1432_setSpan(vi, chan, span);
        if(vierr)
	    return vierr;

	vierr=hpe1432_setBlocksize(vi, chan, blocksize);
        if(vierr)
	    return vierr;

	vierr=hpe1432_setInputMode(vi, chan, inputmode);
        if(vierr)
	    return vierr;

	vierr=hpe1432_setCoupling(vi, chan, coupling);
        if(vierr)
	    return vierr;
    }

    vierr=hpe1432_setDataMode(vi, arraygroupid, E1432_BLOCK_MODE);
    if(vierr)
        return vierr;

    vierr=hpe1432_initMeasure(vi, arraygroupid);
    if(vierr)
        return vierr;

    return VI_SUCCESS;
}

ViStatus _VI_FUNC
hpe1432_arrayNextChan(ViSession vi, ViPInt32 chan)
{
ViStatus 	vierr;
ViInt32	flag;

    if(!chan)
       return(VI_ERROR_PARAMETER2);

    *chan=0;

    vierr=hpe1432_blockAvailable(vi, arraygroupid, &flag);
    if(vierr)
	return vierr;

    /* if data is available, send channel number of next block */
    if(flag==VI_TRUE)
    {
	*chan=arraychanlist[arrayindex];
    }

    return VI_SUCCESS;
}


ViStatus _VI_FUNC
hpe1432_arrayReadChan(ViSession vi, ViPInt32 chan, ViReal64 data[])
{
ViStatus 	vierr;
ViInt32		c;
ViInt32		actualCnt;


    if(!arraygroupid)
       return(VI_ERROR_PARAMETER2);

    if(!chan)
       return(VI_ERROR_PARAMETER2);

    if(!data)
       return(VI_ERROR_PARAMETER3);

    /* wait for data */
    c=0;
    while(!c)
    {
        vierr=hpe1432_arrayNextChan(vi, &c);
        if(vierr)
	    return vierr;
    }
    /* data ready, tell user what chan is being read */
    *chan=c;

    /* get the data */
    vierr=hpe1432_readFloat64Data(vi, c, HPE1432_TIME_DATA,
		data, arrayblocksize[arrayindex], &actualCnt,1);

    arrayindex++;
    if(arrayindex>=arraynumchans)
	arrayindex=0;

    return(vierr);
}


ViStatus _VI_FUNC
hpe1432_getXferSize  (ViSession vi, ViInt32 group, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_xfer_size(semaID,(SHORTSIZ16)group,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_getXferSizeLimits  (ViSession vi, ViInt32 group, ViPReal64 min,
			    ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_xfer_size_limits(semaID,(SHORTSIZ16)group,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}

ViStatus _VI_FUNC
hpe1432_setXferSize  (ViSession vi, ViInt32 group, ViInt32 xferSize)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_xfer_size(semaID,(SHORTSIZ16)group,(LONGSIZ32)xferSize);
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_getSerialNum  (ViSession vi, ViInt32 la, ViChar serial[])
{
struct e1432_hwconfig conf;
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16 add;

        add=(SHORTSIZ16)la;
	serror=e1432_get_hwconfig((SHORTSIZ16)1, &add, &conf);
	if(serror)
            return err1432_to_PNP(serror);

	strncpy(serial,conf.serial,20);
    	return VI_SUCCESS;
}


ViStatus _VI_FUNC
hpe1432_getHWConfig  (ViSession vi, ViInt32 modCount, ViInt32 address[],
		      ViInt32 configInfo[])
{
int i;
int ind;
struct e1432_hwconfig conf;
int confflag;
int p;  /* answer pointer */
SHORTSIZ16 add;
SHORTSIZ16	serror; /* e1432 error */ 


    if (modCount<=0) return VI_SUCCESS; /* that was easy */
    p=0;
    for(i=0;i<modCount;i++)
    {
	add=(SHORTSIZ16)address[i];
	confflag=0;

        /* try to find the module in the LAs array, and use that info */
	for(ind=0;ind<nummodules;ind++)
	{
	     if(LAs[ind]==add)
	     {
		 if(hwconfig[ind].man_id) /* if in use */
		 {
		     conf= hwconfig[ind]; /* found it */
		     confflag=1;
		     break;
		 }
	     }
	}

	/* go to the hardware if not found */
	if(!confflag)
	{
	    serror=e1432_get_hwconfig((SHORTSIZ16)1, &add, &conf);
	    if(serror)
                return err1432_to_PNP(serror);
	}
	
	configInfo[p]=(0xfff)&((ViInt32)conf.man_id);/* VXI Manufacturer ID */
	/* set bit 12 if octave present */
	if(conf.oct_present)
	    configInfo[p]|=0x1000;
	p++;

	configInfo[p++]=(ViInt32)conf.model_code;/* VXI Model code */
	configInfo[p++]=(ViInt32)conf.hw_rev;/* Hardware revision */
	configInfo[p++]=(ViInt32)conf.bootrom_rev;/* Bootrom revision */
	configInfo[p++]=(ViInt32)conf.fw_rev;/* Firmware revision */

	configInfo[p++]=(ViInt32)conf.sca_id[0];/* What SCAs are present */
	configInfo[p++]=(ViInt32)conf.sca_id[1];/* What SCAs are present */
	configInfo[p++]=(ViInt32)conf.sca_id[2];/* What SCAs are present */
	configInfo[p++]=(ViInt32)conf.sca_id[3];/* What SCAs are present */
	configInfo[p++]=(ViInt32)conf.sca_id[4];/* What SCAs are present */

	configInfo[p++]=(ViInt32)conf.sca_rev[0];/* SCA-specific revision */
	configInfo[p++]=(ViInt32)conf.sca_rev[1];/* SCA-specific revision */
	configInfo[p++]=(ViInt32)conf.sca_rev[2];/* SCA-specific revision */
	configInfo[p++]=(ViInt32)conf.sca_rev[3];/* SCA-specific revision */
	configInfo[p++]=(ViInt32)conf.sca_rev[4];/* SCA-specific revision */

	configInfo[p++]=(ViInt32)conf.bob_id[0];/* What break-out boxes */
	configInfo[p++]=(ViInt32)conf.bob_id[1];/* What break-out boxes */
	configInfo[p++]=(ViInt32)conf.bob_id[2];/* What break-out boxes */
	configInfo[p++]=(ViInt32)conf.bob_id[3];/* What break-out boxes */
	configInfo[p++]=(ViInt32)conf.bob_id[4];/* What break-out boxes */

	configInfo[p++]=(ViInt32)conf.total_chans;/* Total channels available */
	configInfo[p++]=(ViInt32)conf.input_chans;/* Total input channels */
	configInfo[p++]=(ViInt32)conf.source_chans;/* Total source channels */
	configInfo[p++]=(ViInt32)conf.tach_chans;/* Total tach channels */
	configInfo[p++]=(ViInt32)conf.lbus_present;/* Is local bus present */

	configInfo[p++]=(ViInt32)conf.dram_size;/* Total DRAM size */
	configInfo[p++]=(ViInt32)conf.a24_used;/*  a24_used */

    }

    return VI_SUCCESS;
}


ViStatus _VI_FUNC
hpe1432_getAvgUpdate  (ViSession vi, ViInt32 group, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_avg_update(semaID, (SHORTSIZ16)group, &semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getAvgUpdateLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_avg_update_limits(semaID,(SHORTSIZ16)group,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_setAvgUpdate  (ViSession vi, ViInt32 group, ViInt32 avgUp)
{
SHORTSIZ16	serror; /* e1432 error */ 

   serror=e1432_set_avg_update(semaID, (SHORTSIZ16)group, (LONGSIZ32)avgUp);
   return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getAvgWeight  (ViSession vi, ViInt32 group, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror= e1432_get_avg_weight(semaID, (SHORTSIZ16)group,&semparm );
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getAvgWeightLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_avg_weight_limits(semaID,(SHORTSIZ16)group,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_setAvgWeight  (ViSession vi, ViInt32 group, ViReal64 avgWt)
{
SHORTSIZ16	serror; /* e1432 error */ 

   serror=e1432_set_avg_weight(semaID, (SHORTSIZ16)group, (FLOATSIZ32)avgWt);
   return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getSrcParmMode  (ViSession vi, ViInt32 group, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */
ViStatus	rv;

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_srcparm_mode(semaID,(SHORTSIZ16)group,&semparm);
    if(serror)
        return err1432_to_PNP(serror);

    rv=VI_SUCCESS;
    switch(semparm){
    case E1432_SRCPARM_MODE_DEFR:
	*viparm=HPE1432_SRCPARM_MODE_DEFR;
	break;
    case E1432_SRCPARM_MODE_IMMED:
	*viparm=HPE1432_SRCPARM_MODE_IMMED;
	break;
    default:
	rv=VI_ERROR_PARAMETER3;
	break;
    }

   return rv;
}


ViStatus _VI_FUNC
hpe1432_setSrcParmMode  (ViSession vi, ViInt32 group, ViInt32 srcParmMode)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	pm;

    switch(srcParmMode){
    case HPE1432_SRCPARM_MODE_DEFR:
	pm=E1432_SRCPARM_MODE_DEFR;
	break;
    case HPE1432_SRCPARM_MODE_IMMED:
	pm=E1432_SRCPARM_MODE_IMMED;
	break;
    default:
	return VI_ERROR_PARAMETER3;
    }

    serror=e1432_set_srcparm_mode(semaID,(SHORTSIZ16)group,pm);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getSrcOffMode  (ViSession vi, ViInt32 group, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */
ViStatus	rv;

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_srcoff_mode(semaID,(SHORTSIZ16)group,&semparm);
    if(serror)
        return err1432_to_PNP(serror);

    rv=VI_SUCCESS;
    switch(semparm){
    case E1432_SRCOFF_MODE_RAMP:
	*viparm=HPE1432_SRCOFF_MODE_RAMP;
	break;
    case E1432_SRCOFF_MODE_IMMED:
	*viparm=HPE1432_SRCOFF_MODE_IMMED;
	break;
    default:
	rv=VI_ERROR_PARAMETER3;
	break;
    }

   return rv;
}


ViStatus _VI_FUNC
hpe1432_setSrcOffMode  (ViSession vi, ViInt32 group, ViInt32 srcOffMode)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	pm;

    switch(srcOffMode){
    case HPE1432_SRCOFF_MODE_RAMP:
	pm=E1432_SRCOFF_MODE_RAMP;
	break;
    case HPE1432_SRCOFF_MODE_IMMED:
	pm=E1432_SRCOFF_MODE_IMMED;
	break;
    default:
	return VI_ERROR_PARAMETER3;
    }

    serror=e1432_set_srcoff_mode(semaID,(SHORTSIZ16)group,pm);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_updateSrcParm  (ViSession vi, ViInt32 group, ViInt32 updateMode)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	um;

    switch(updateMode){

    case HPE1432_SRCPARM_UPDATE_IMMED:
	um=E1432_SRCPARM_UPDATE_IMMED;
	break;
    case HPE1432_SRCPARM_UPDATE_XING:
	um=E1432_SRCPARM_UPDATE_XING;
	break;
    case HPE1432_SRCPARM_UPDATE_TRGIN:
	um=E1432_SRCPARM_UPDATE_TRGIN;
	break;
    case HPE1432_SRCPARM_UPDATE_IMMEDTRGOUT:
	um=E1432_SRCPARM_UPDATE_IMMEDTRGOUT;
	break;
    case HPE1432_SRCPARM_UPDATE_XINGTRGOUT:
	um=E1432_SRCPARM_UPDATE_XINGTRGOUT;
	break;
    default:
	return VI_ERROR_PARAMETER3;
    }

    serror=e1432_update_srcparm(semaID,(SHORTSIZ16)group,um);
    return err1432_to_PNP(serror);
}



#ifdef INSTR_CALLBACKS

ViStatus _VI_FUNC
hpe1432_callbackInstall  (ViSession vi, ViInt32 channel,
			  hpe1432_callbackFunc cbFunc, ViInt32 value)
{
    return (ViStatus)vtl_install_callback ((LONGSIZ32)semaID,
					   (LONGSIZ32)channel,
					   cbFunc,
					   (LONGSIZ32)value);
}

#endif /* INSTR_CALLBACKS */




ViStatus _VI_FUNC
hpe1432_readRegister16  (ViSession vi, ViInt32 channel,
			 ViInt32 reg, ViPInt16 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_read_register(semaID,(SHORTSIZ16)channel,
			       (LONGSIZ32)reg,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_readRegister32  (ViSession vi, ViInt32 channel,
			 ViInt32 reg, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_read32_register(semaID,(SHORTSIZ16)channel,
			       (LONGSIZ32)reg,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_writeRegister16  (ViSession vi, ViInt32 channel, 
			  ViInt32 reg, ViInt16 data)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_write_register(semaID,(SHORTSIZ16)channel,
				(LONGSIZ32)reg, (SHORTSIZ16)data);
    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_writeRegister32  (ViSession vi, ViInt32 channel,
			  ViInt32 reg, ViInt32 data)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_write32_register(semaID,(SHORTSIZ16)channel,
				  (LONGSIZ32)reg,(LONGSIZ32)data);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_readI2C  (ViSession vi, ViInt32 group, ViInt32 address,
		  ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_read_i2c(semaID,(SHORTSIZ16)group,(SHORTSIZ16)address,
			  &semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_writeI2C  (ViSession vi, ViInt32 group, ViInt32 address,
		   ViInt32 i2cdata)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_write_i2c(semaID,(SHORTSIZ16)group,(SHORTSIZ16)address,
			   (SHORTSIZ16)i2cdata);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getPeakHoldTime(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_peak_hold_time(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getPeakHoldTimeLimits  (ViSession vi, ViInt32 channel, ViPReal64 min,
				ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_peak_hold_time_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_setPeakHoldTime(ViSession vi, ViInt32 channel, ViReal64 holdTime)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_peak_hold_time(semaID,(SHORTSIZ16)channel,
				    (FLOATSIZ32)holdTime);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getRmsDecayTime(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_rms_decay_time(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getRmsDecayTimeLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
			      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_rms_decay_time_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_setRmsDecayTime(ViSession vi, ViInt32 channel, ViReal64 decayTime)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_rms_decay_time(semaID,(SHORTSIZ16)channel,
				    (FLOATSIZ32)decayTime);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setRmsSpan(ViSession vi, ViInt32 channel, ViReal64 span)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_rms_span(semaID,(SHORTSIZ16)channel,(FLOATSIZ32)span);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRmsSpan(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_rms_span(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRmsSpanLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_rms_span_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setPeakSpan(ViSession vi, ViInt32 channel, ViReal64 span)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_peak_span(semaID,(SHORTSIZ16)channel,(FLOATSIZ32)span);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getPeakSpan(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_peak_span(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getPeakSpanLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_peak_span_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_setHpfSpan(ViSession vi, ViInt32 channel, ViReal64 span)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_hpf_span(semaID,(SHORTSIZ16)channel,(FLOATSIZ32)span);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getHpfSpan(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_hpf_span(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getHpfSpanLimits(ViSession vi, ViInt32 channel, ViPReal64 min,
		      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_hpf_span_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC
hpe1432_scaDspDownload  (ViSession vi, ViInt32 group, ViInt32 length,
			 ViPInt32 data)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_sca_dsp_download(semaID, (SHORTSIZ16)group, (LONGSIZ32)length,
				  data);
    return err1432_to_PNP(serror);

}


ViStatus _VI_FUNC
hpe1432_scaDspExecQuery  (ViSession vi, ViInt32 group, ViInt32 exec_cmd,
			  ViInt32 exec_data_size, ViPInt32 exec_data,
			  ViInt32 query_data_size, ViPInt32 query_data)
{
SHORTSIZ16	serror; /* e1432 error */ 


    serror=e1432_dsp_exec_query(semaID, (SHORTSIZ16)group,
				    exec_cmd,
			 	    exec_data_size, exec_data,
			            query_data_size, query_data );
    return err1432_to_PNP(serror);

}


#ifdef	INSTR_REAL32
ViStatus _VI_FUNC
hpe1432_readFloat32Spectrum  (ViSession vi, ViInt32 group, ViReal32 data[],
			      ViInt32 size, ViPInt32 actualCnt)
{
SHORTSIZ16	serror; /* e1432 error */ 

    if(!data)
       return(HPE1432_ERR_NULL_POINTER);
    if(!actualCnt)
       return(HPE1432_ERR_NULL_POINTER);


    serror=e1432_read_float32_spectrum(semaID, (SHORTSIZ16)group,
				      data, size,
				      &last_trailer, actualCnt);
    return err1432_to_PNP(serror);

}
#endif



ViStatus _VI_FUNC
hpe1432_readFloat64Spectrum  (ViSession vi, ViInt32 group, ViReal64 data[],
			      ViInt32 size, ViPInt32 actualCnt)
{
SHORTSIZ16	serror; /* e1432 error */ 

    if(!data)
       return(HPE1432_ERR_NULL_POINTER);
    if(!actualCnt)
       return(HPE1432_ERR_NULL_POINTER);


    serror=e1432_read_float64_spectrum(semaID, (SHORTSIZ16)group,
				      data, size,
				      &last_trailer, actualCnt);
    return err1432_to_PNP(serror);

}



ViStatus _VI_FUNC
hpe1432_requestSpectrum  (ViSession vi, ViInt32 group, ViReal64 span,
			  ViInt32 blocksize, ViInt32 avgNum,
			  ViInt32 avgMode, ViInt32 window)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_request_spectrum(semaID, (SHORTSIZ16)group,
				  (FLOATSIZ32)span, (LONGSIZ32)blocksize,
				(LONGSIZ32)avgNum, (SHORTSIZ16)avgMode,
				(SHORTSIZ16)window);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_checkSpectrum  (ViSession vi, ViInt32 group, ViInt32 block,
			ViPInt32 ready)
{
SHORTSIZ16	serror; /* e1432 error */ 


    *ready=0;

    serror=e1432_check_spectrum(semaID, (SHORTSIZ16)group, (SHORTSIZ16)block);
    if(serror>0)
	*ready=1;

    else if(serror<0)
	return err1432_to_PNP(serror);

    return(VI_SUCCESS);
}



ViStatus _VI_FUNC
hpe1432_getCurrentPeak(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_current_peak(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getCurrentRms(ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_current_rms(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_srcGetFwrev  (ViSession vi, ViInt32 dptr[], ViPInt32 fwid,
		      ViPInt32 fwdate, ViInt32 numwords)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_src_get_fwrev(dptr, fwid, fwdate, numwords);

    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_srcGetRev  (ViSession vi, ViInt32 group,
		      ViPInt32 romid, ViPInt32 romdate,
		      ViPInt32 bdid, ViChar bddate[])
{
SHORTSIZ16	serror; /* e1432 error */ 

    if(group<1)
        return(VI_ERROR_PARAMETER2);

    serror=e1432_src_get_rev(semaID, (SHORTSIZ16)group, romid, romdate ,
			     bdid , bddate );

    return err1432_to_PNP(serror);
}

ViStatus _VI_FUNC
hpe1432_srcProgRomImage  (ViSession vi, ViInt32 group,
			    ViInt32 data[], ViInt32 numwords)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_src_prog_romimage(semaID, (SHORTSIZ16)group, data, numwords);

    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_srcRxfr  (ViSession vi, ViInt32 group,
		    ViInt32 numwords, ViInt32 data[],
		    ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_src_rxfr(semaID, (SHORTSIZ16)group, numwords, data , mode);

    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getMmfDelay  (ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_mmf_delay(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_setMmfDelay  (ViSession vi, ViInt32 channel, ViInt32 mmfdelay)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_mmf_delay(semaID,(SHORTSIZ16)channel,mmfdelay);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getTrigCorr  (ViSession vi, ViInt32 channel, ViPReal64 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
FLOATSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_trig_corr(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getSamplesToPreArm  (ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
LONGSIZ32	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_samples_to_pre_arm(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}




/******************************************************************/

ViStatus _VI_FUNC 
hpe1432_channelGroupAdd  (ViSession vi, ViInt32 group, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_channel_group_add(semaID,(SHORTSIZ16)group,
				     (SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_channelGroupRemove  (ViSession vi, ViInt32 group, ViInt32 channel)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_channel_group_remove(semaID,(SHORTSIZ16)group,
				     (SHORTSIZ16)channel);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getAutoRangeMode  (ViSession vi, ViInt32 group, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_auto_range_mode(semaID,(SHORTSIZ16)group,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_getCurrentValue  (ViSession vi, ViInt32 channel, ViInt32 valueType,
			  ViPReal64 curVal)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    if(channel<1)
        return VI_ERROR_PARAMETER2; /* want channel */
    serror=e1432_get_current_value(semaID,(SHORTSIZ16)channel,
				   (SHORTSIZ16)valueType,&r);
    *curVal=r;
    return err1432_to_PNP(serror);
}


#ifdef INSTR_REAL32
/* this version supports group reads */
ViStatus _VI_FUNC 
hpe1432_getCurrentValue32  (ViSession vi, ViInt32 group, ViInt32 valueType,
			    ViPReal32 curVal)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_current_value(semaID,(SHORTSIZ16)group,
				     (SHORTSIZ16)valueType,curVal);
    return err1432_to_PNP(serror);
}
#endif


ViStatus _VI_FUNC 
hpe1432_getPeakDecayTime  (ViSession vi, ViInt32 group, ViPReal64 peakDecayTime)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_peak_decay_time(semaID,(SHORTSIZ16)group,&r);
    *peakDecayTime=r;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getPeakDecayTimeLimits  (ViSession vi, ViInt32 group, ViPReal64 min,
				 ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_peak_decay_time_limits(semaID,(SHORTSIZ16)group,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_getPeakMode  (ViSession vi, ViInt32 group, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_peak_mode(semaID,(SHORTSIZ16)group,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRmsAvgTime  (ViSession vi, ViInt32 group, ViPReal64 rmsAvgTime)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_rms_avg_time(semaID,(SHORTSIZ16)group,&r);
    *rmsAvgTime=r;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_getRmsAvgTimeLimits  (ViSession vi, ViInt32 group, ViPReal64 min,
			      ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_rms_avg_time_limits(semaID,(SHORTSIZ16)group,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}


ViStatus _VI_FUNC 
hpe1432_getRmsMode  (ViSession vi, ViInt32 group, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_rms_mode(semaID,(SHORTSIZ16)group,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setAutoRangeMode  (ViSession vi, ViInt32 group, ViInt32 rangeMode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_auto_range_mode(semaID,(SHORTSIZ16)group,
				     (SHORTSIZ16)rangeMode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setPeakDecayTime  (ViSession vi, ViInt32 group, ViReal64 peakDecayTime)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_peak_decay_time(semaID,(SHORTSIZ16)group,
				    (FLOATSIZ32)peakDecayTime);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setPeakMode  (ViSession vi, ViInt32 group, ViInt32 peakMode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_peak_mode(semaID,(SHORTSIZ16)group,(SHORTSIZ16)peakMode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setRmsAvgTime  (ViSession vi, ViInt32 group, ViReal64 rmsAvgTime)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_rms_avg_time(semaID,(SHORTSIZ16)group,
				    (FLOATSIZ32)rmsAvgTime);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setRmsMode  (ViSession vi, ViInt32 group, ViInt32 rmsMode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_rms_mode(semaID,(SHORTSIZ16)group,(SHORTSIZ16)rmsMode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_displayState  (ViSession vi)
{
    e1432_display_state(semaID);
    return VI_SUCCESS;
}

ViStatus _VI_FUNC
hpe1432_setTraceLevel(ViSession vi,ViInt32 tlevel)
{


    pnptracelevel=tlevel;

    if(tlevel&1)
	e1432_trace_level(1);

    return VI_SUCCESS;
}

void flog(char *line)
{
FILE *fd;

#ifdef MICROSOFT_OS
	fd=fopen("C:\\e1432.log","a");
#else
	fd=fopen("/tmp/e1432.log","a");
#endif
	if(fd)
	{
	    fprintf(fd,"%s",line);
	    fclose(fd);
	}
	return;
}


int flogprintf(char *fmt,...)
{
char aline[500];
va_list ap;
#ifndef MICROSOFT_OS
va_dcl
#endif

#ifdef MICROSOFT_OS
    va_start(ap,fmt);
#else
    va_start(ap);
#endif
    sprintf(aline,fmt,ap);
    va_end(ap);
    flog(aline);
    return 0;

}

/* octave funcs */

ViStatus _VI_FUNC 
hpe1432_getOctaveMode(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_octave_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setOctaveMode(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}




ViStatus _VI_FUNC 
hpe1432_getOctaveMeas(ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_octave_meas(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setOctaveMeas(ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_meas(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}




ViStatus _VI_FUNC
hpe1432_octaveCtl  (ViSession vi, ViInt32 channel, ViInt32 octCtl)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_octave_ctl(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)octCtl);
    return err1432_to_PNP(serror);
}




ViStatus _VI_FUNC
hpe1432_setOctaveAvgMode  (ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_avg_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setOctaveHoldMode  (ViSession vi, ViInt32 channel, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_hold_mode(semaID,(SHORTSIZ16)channel,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setOctaveIntTime  (ViSession vi, ViInt32 group, ViReal64 octIntTime)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_int_time(semaID,(SHORTSIZ16)group,(FLOATSIZ32)octIntTime);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setOctaveStartFreq  (ViSession vi, ViInt32 group, ViReal64 octStartFreq)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_start_freq(semaID,(SHORTSIZ16)group,(FLOATSIZ32)octStartFreq);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setOctaveStopFreq  (ViSession vi, ViInt32 channel, ViReal64 octStopFreq)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_stop_freq(semaID,(SHORTSIZ16)channel,(FLOATSIZ32)octStopFreq);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setOctaveTimeConst (ViSession vi, ViInt32 channel, ViReal64 octTimeConst)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_time_const(semaID,(SHORTSIZ16)channel,(FLOATSIZ32)octTimeConst);
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC 
hpe1432_setOctaveTimeStep  (ViSession vi, ViInt32 channel, ViReal64 octTimeStep)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_octave_time_step(semaID,(SHORTSIZ16)channel,(FLOATSIZ32)octTimeStep);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getOctaveAvgMode  (ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_octave_avg_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getOctaveBlocksize  (ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_octave_blocksize(semaID,(SHORTSIZ16)channel,viparm);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getOctaveHoldMode  (ViSession vi, ViInt32 channel, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_octave_hold_mode(semaID,(SHORTSIZ16)channel,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC 
hpe1432_getOctaveIntTime  (ViSession vi, ViInt32 channel, ViPReal64 parm)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_int_time(semaID,(SHORTSIZ16)channel,&r);
    *parm=r;
    return err1432_to_PNP(serror);
}




ViStatus _VI_FUNC 
hpe1432_getOctaveIntTimeLimits(ViSession vi, ViInt32 channel, ViPReal64 min ,
		   ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_int_time_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}



ViStatus _VI_FUNC 
hpe1432_getOctaveStartFreq  (ViSession vi, ViInt32 channel, ViPReal64 rate)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_start_freq(semaID,(SHORTSIZ16)channel,&r);
    *rate=r;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getOctaveStartFreqLimits  (ViSession vi, ViInt32 channel, ViPReal64 min,
				ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_start_freq_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}



ViStatus _VI_FUNC 
hpe1432_getOctaveStopFreq  (ViSession vi, ViInt32 channel, ViPReal64 rate)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_stop_freq(semaID,(SHORTSIZ16)channel,&r);
    *rate=r;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getOctaveStopFreqLimits  (ViSession vi, ViInt32 channel, ViPReal64 min,
			     ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_stop_freq_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}



ViStatus _VI_FUNC 
hpe1432_getOctaveTimeConst  (ViSession vi, ViInt32 channel, ViPReal64 rate)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_time_const(semaID,(SHORTSIZ16)channel,&r);
    *rate=r;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getOctaveTimeConstLimits  (ViSession vi, ViInt32 channel, ViPReal64 min,
			       ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_time_const_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}



ViStatus _VI_FUNC 
hpe1432_getOctaveTimeStep  (ViSession vi, ViInt32 channel, ViPReal64 rate)
{
FLOATSIZ32	r;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_time_step(semaID,(SHORTSIZ16)channel,&r);
    *rate=r;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getOctaveTimeStepLimits  (ViSession vi, ViInt32 channel, ViPReal64 min,
			       ViPReal64 max, ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_octave_time_step_limits(semaID,(SHORTSIZ16)channel,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}




ViStatus _VI_FUNC
hpe1432_setUserData  (ViSession vi, ViInt32 group, ViInt32 frameLen,
		      ViInt32 wordLen, ViInt32 subLen, ViInt32 subPos)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_user_data(semaID,(SHORTSIZ16)group, frameLen,
			       (SHORTSIZ16)wordLen,
			       (SHORTSIZ16)subLen,
			       (SHORTSIZ16)subPos);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getSampleMode  (ViSession vi, ViInt32 group, ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_sample_mode(semaID,(SHORTSIZ16)group,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}


ViStatus _VI_FUNC
hpe1432_setSampleMode  (ViSession vi, ViInt32 group, ViInt32 mode)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_set_sample_mode(semaID,(SHORTSIZ16)group,(SHORTSIZ16)mode);
    return err1432_to_PNP(serror);
}




ViStatus _VI_FUNC
hpe1432_setUserWindow  (ViSession vi, ViInt32 group, ViReal64 window[],
			 ViReal64 scale)
{
SHORTSIZ16	serror; /* e1432 error */ 

    if(!window)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_set_user_window(semaID, (SHORTSIZ16)group, window, scale);
    return err1432_to_PNP(serror);

}



ViStatus _VI_FUNC
hpe1432_getDecimationUndersamp  (ViSession vi, ViInt32 group,
				 ViPInt32 viparm)
{
SHORTSIZ16	serror; /* e1432 error */ 
SHORTSIZ16	semparm; /* semaphore parm */

    if(!viparm)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_get_decimation_undersamp(semaID,(SHORTSIZ16)group,&semparm);
    *viparm=semparm;
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getDecimationUndersampLimits  (ViSession vi, ViInt32 group,
				       ViPReal64 min, ViPReal64 max,
				       ViPReal64 def, ViPReal64 step)
{
FLOATSIZ32	fmin,fmax,fdef,fstep;
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_decimation_undersamp_limits(semaID,(SHORTSIZ16)group,
				  &fmin,&fmax,&fdef,&fstep);
    if(serror)
	return err1432_to_PNP(serror);

    if(min)
	*min=fmin;
    if(max)
	*max=fmax;
    if(def)
	*def=fdef;
    if(step)
	*step=fstep;

    return(VI_SUCCESS);
}



ViStatus _VI_FUNC
hpe1432_setDecimationUndersamp  (ViSession vi, ViInt32 group,
				 ViInt32 undersamp)
{
SHORTSIZ16	serror; /* e1432 error */ 

    if(!undersamp)
       return(VI_ERROR_PARAMETER3);

    serror=e1432_set_decimation_undersamp(semaID, (SHORTSIZ16)group, 
				          (SHORTSIZ16)undersamp);
    return err1432_to_PNP(serror);
}



ViStatus _VI_FUNC
hpe1432_getFwrev  (ViSession vi, ViChar path[], ViPInt32 fwrev)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_fwrev(path, fwrev);
    return err1432_to_PNP(serror);

}



ViStatus _VI_FUNC
hpe1432_getCurrentData  (ViSession vi, ViInt32 group, ViInt32 datatype,
			 ViInt32 datasize, ViChar data[], ViPInt32 actualCnt)
{
SHORTSIZ16	serror; /* e1432 error */ 

    serror=e1432_get_current_data(semaID, (SHORTSIZ16)group,
				  (SHORTSIZ16)datatype, (SHORTSIZ16)datasize,
		                  (void **)data, (LONGSIZ32 *)actualCnt);
    return err1432_to_PNP(serror);
}



#endif /* VXIPNP */

/* this next line is here to stop a silly compiler warning for non PLUG&PLAY */
extern int hpplug_quiet;



